# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .organization_usage_enum import OrganizationUsageEnum


class OrganizationClientGrant(UniversalBaseModel):
    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the client grant.
    """

    client_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the client.
    """

    audience: typing.Optional[str] = pydantic.Field(default=None)
    """
    The audience (API identifier) of this client grant
    """

    scope: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Scopes allowed for this client grant.
    """

    organization_usage: typing.Optional[OrganizationUsageEnum] = None
    allow_any_organization: typing.Optional[bool] = pydantic.Field(default=None)
    """
    If enabled, any organization can be used with this grant. If disabled (default), the grant must be explicitly assigned to the desired organizations.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
