# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .app_metadata import AppMetadata
from .organization_invitation_invitee import OrganizationInvitationInvitee
from .organization_invitation_inviter import OrganizationInvitationInviter
from .user_metadata import UserMetadata


class OrganizationInvitation(UniversalBaseModel):
    id: typing.Optional[str] = pydantic.Field(default="uinv_0000000000000001")
    """
    The id of the user invitation.
    """

    organization_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Organization identifier.
    """

    inviter: typing.Optional[OrganizationInvitationInviter] = None
    invitee: typing.Optional[OrganizationInvitationInvitee] = None
    invitation_url: typing.Optional[str] = pydantic.Field(
        default="https://mycompany.org/login?invitation=f81dWWYW6gzGGicxT8Ha0txBkGNcAcYr&organization=org_0000000000000001&organization_name=acme"
    )
    """
    The invitation url to be send to the invitee.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The ISO 8601 formatted timestamp representing the creation time of the invitation.
    """

    expires_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The ISO 8601 formatted timestamp representing the expiration time of the invitation.
    """

    client_id: typing.Optional[str] = pydantic.Field(default="AaiyAPdpYdesoKnqjj8HJqRn4T5titww")
    """
    Auth0 client ID. Used to resolve the application's login initiation endpoint.
    """

    connection_id: typing.Optional[str] = pydantic.Field(default="con_0000000000000001")
    """
    The id of the connection to force invitee to authenticate with.
    """

    app_metadata: typing.Optional[AppMetadata] = None
    user_metadata: typing.Optional[UserMetadata] = None
    roles: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of roles IDs to associated with the user.
    """

    ticket_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the invitation ticket
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
