# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .public_key_credential_algorithm_enum import PublicKeyCredentialAlgorithmEnum
from .public_key_credential_type_enum import PublicKeyCredentialTypeEnum


class PublicKeyCredential(UniversalBaseModel):
    credential_type: PublicKeyCredentialTypeEnum = "public_key"
    name: typing.Optional[str] = pydantic.Field(default="")
    """
    Friendly name for a credential.
    """

    pem: str = pydantic.Field(default="-----BEGIN PUBLIC KEY-----\r\nMIIBIjANBg...\r\n-----END PUBLIC KEY-----\r\n")
    """
    PEM-formatted public key (SPKI and PKCS1) or X509 certificate. Must be JSON escaped.
    """

    alg: typing.Optional[PublicKeyCredentialAlgorithmEnum] = None
    parse_expiry_from_cert: typing.Optional[bool] = pydantic.Field(default=False)
    """
    Parse expiry from x509 certificate. If true, attempts to parse the expiry date from the provided PEM. Applies to `public_key` credential type.
    """

    expires_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The ISO 8601 formatted date representing the expiration of the credential. If not specified (not recommended), the credential never expires. Applies to `public_key` credential type.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
