# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class RefreshTokenDevice(UniversalBaseModel):
    """
    Device used while issuing/exchanging the refresh token
    """

    initial_ip: typing.Optional[str] = pydantic.Field(default=None)
    """
    First IP address associated with the refresh token
    """

    initial_asn: typing.Optional[str] = pydantic.Field(default=None)
    """
    First autonomous system number associated with the refresh token
    """

    initial_user_agent: typing.Optional[str] = pydantic.Field(default=None)
    """
    First user agent associated with the refresh token
    """

    last_ip: typing.Optional[str] = pydantic.Field(default=None)
    """
    Last IP address associated with the refresh token
    """

    last_asn: typing.Optional[str] = pydantic.Field(default=None)
    """
    Last autonomous system number associated with the refresh token
    """

    last_user_agent: typing.Optional[str] = pydantic.Field(default=None)
    """
    Last user agent associated with the refresh token
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
