# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .resource_server_token_encryption_algorithm_enum import ResourceServerTokenEncryptionAlgorithmEnum


class ResourceServerTokenEncryptionKey(UniversalBaseModel):
    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the encryption key.
    """

    alg: ResourceServerTokenEncryptionAlgorithmEnum
    kid: typing.Optional[str] = pydantic.Field(default=None)
    """
    Key ID.
    """

    pem: str = pydantic.Field(default="-----BEGIN PUBLIC KEY-----\r\nMIIBIjANBg...\r\n-----END PUBLIC KEY-----\r\n")
    """
    PEM-formatted public key. Must be JSON escaped.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
