# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class ScimTokenItem(UniversalBaseModel):
    token_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The token's identifier
    """

    scopes: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The scopes of the scim token
    """

    created_at: typing.Optional[str] = pydantic.Field(default=None)
    """
    The token's created at timestamp
    """

    valid_until: typing.Optional[str] = pydantic.Field(default=None)
    """
    The token's valid until timestamp
    """

    last_used_at: typing.Optional[str] = pydantic.Field(default=None)
    """
    The token's last used at timestamp
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
