# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .connections_metadata import ConnectionsMetadata
from .self_service_profile_sso_ticket_connection_options import SelfServiceProfileSsoTicketConnectionOptions


class SelfServiceProfileSsoTicketConnectionConfig(UniversalBaseModel):
    """
    If provided, this will create a new connection for the SSO flow with the given configuration
    """

    name: str = pydantic.Field(default="sso-generated-SAML-customer-12")
    """
    The name of the connection that will be created as a part of the SSO flow.
    """

    display_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Connection name used in the new universal login experience
    """

    is_domain_connection: typing.Optional[bool] = pydantic.Field(default=None)
    """
    <code>true</code> promotes to a domain-level connection so that third-party applications can use it. <code>false</code> does not promote the connection, so only first-party applications with the connection enabled can use it. (Defaults to <code>false</code>.)
    """

    show_as_button: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Enables showing a button for the connection in the login page (new experience only). If false, it will be usable only by HRD. (Defaults to <code>false</code>.)
    """

    metadata: typing.Optional[ConnectionsMetadata] = None
    options: typing.Optional[SelfServiceProfileSsoTicketConnectionOptions] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
