# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .session_date import SessionDate


class SessionAuthenticationSignal(UniversalBaseModel):
    """
    Authentication signal details
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    One of: "federated", "passkey", "pwd", "sms", "email", "mfa", "mock" or a custom method denoted by a URL
    """

    timestamp: typing.Optional[SessionDate] = None
    type: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="^type$")] = pydantic.Field(
        default=None
    )
    """
    A specific MFA factor. Only present when "name" is set to "mfa"
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
