# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .session_ip import SessionIp


class SessionDeviceMetadata(UniversalBaseModel):
    """
    Metadata related to the device used in the session
    """

    initial_user_agent: typing.Optional[str] = pydantic.Field(default=None)
    """
    First user agent of the device from which this user logged in
    """

    initial_ip: typing.Optional[SessionIp] = None
    initial_asn: typing.Optional[str] = pydantic.Field(default=None)
    """
    First autonomous system number associated with this session
    """

    last_user_agent: typing.Optional[str] = pydantic.Field(default=None)
    """
    Last user agent of the device from which this user logged in
    """

    last_ip: typing.Optional[SessionIp] = None
    last_asn: typing.Optional[str] = pydantic.Field(default=None)
    """
    Last autonomous system number from which this user logged in
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
