# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .session_authentication_signals import SessionAuthenticationSignals
from .session_client_metadata import SessionClientMetadata
from .session_cookie_metadata import SessionCookieMetadata
from .session_date import SessionDate
from .session_device_metadata import SessionDeviceMetadata
from .session_metadata import SessionMetadata


class SessionResponseContent(UniversalBaseModel):
    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The ID of the session
    """

    user_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the user which can be used when interacting with other APIs.
    """

    created_at: typing.Optional[SessionDate] = None
    updated_at: typing.Optional[SessionDate] = None
    authenticated_at: typing.Optional[SessionDate] = None
    idle_expires_at: typing.Optional[SessionDate] = None
    expires_at: typing.Optional[SessionDate] = None
    last_interacted_at: typing.Optional[SessionDate] = None
    device: typing.Optional[SessionDeviceMetadata] = None
    clients: typing.Optional[typing.List[SessionClientMetadata]] = pydantic.Field(default=None)
    """
    List of client details for the session
    """

    authentication: typing.Optional[SessionAuthenticationSignals] = None
    cookie: typing.Optional[SessionCookieMetadata] = None
    session_metadata: typing.Optional[SessionMetadata] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
