# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .authentication_type_enum import AuthenticationTypeEnum
from .preferred_authentication_method_enum import PreferredAuthenticationMethodEnum


class SetUserAuthenticationMethods(UniversalBaseModel):
    type: AuthenticationTypeEnum
    preferred_authentication_method: typing.Optional[PreferredAuthenticationMethodEnum] = None
    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    AA human-readable label to identify the authentication method.
    """

    phone_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    Applies to phone authentication methods only. The destination phone number used to send verification codes via text and voice.
    """

    email: typing.Optional[str] = pydantic.Field(default=None)
    """
    Applies to email authentication methods only. The email address used to send verification messages.
    """

    totp_secret: typing.Optional[str] = pydantic.Field(default=None)
    """
    Applies to totp authentication methods only. The base32 encoded secret for TOTP generation.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
