# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class TenantSettingsErrorPage(UniversalBaseModel):
    """
    Error page customization.
    """

    html: typing.Optional[str] = pydantic.Field(default="")
    """
    Custom Error HTML (<a href='https://github.com/Shopify/liquid/wiki/Liquid-for-Designers'>Liquid syntax</a> is supported).
    """

    show_log_link: typing.Optional[bool] = pydantic.Field(default=False)
    """
    Whether to show the link to log as part of the default error page (true, default) or not to show the link (false).
    """

    url: typing.Optional[str] = pydantic.Field(default="https://mycompany.org/error")
    """
    URL to redirect to when an error occurs instead of showing the default error page.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
