# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class TenantSettingsFlags(UniversalBaseModel):
    """
    Flags used to change the behavior of this tenant.
    """

    change_pwd_flow_v_1: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="change_pwd_flow_v1")
    ] = pydantic.Field(default=False)
    """
    Whether to use the older v1 change password flow (true, not recommended except for backward compatibility) or the newer safer flow (false, recommended).
    """

    enable_apis_section: typing.Optional[bool] = pydantic.Field(default=False)
    """
    Whether the APIs section is enabled (true) or disabled (false).
    """

    disable_impersonation: typing.Optional[bool] = pydantic.Field(default=False)
    """
    Whether the impersonation functionality has been disabled (true) or not (false). Read-only.
    """

    enable_client_connections: typing.Optional[bool] = pydantic.Field(default=True)
    """
    Whether all current connections should be enabled when a new client (application) is created (true, default) or not (false).
    """

    enable_pipeline_2: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="enable_pipeline2")] = (
        pydantic.Field(default=True)
    )
    """
    Whether advanced API Authorization scenarios are enabled (true) or disabled (false).
    """

    allow_legacy_delegation_grant_types: typing.Optional[bool] = pydantic.Field(default=None)
    """
    If enabled, clients are able to add legacy delegation grants.
    """

    allow_legacy_ro_grant_types: typing.Optional[bool] = pydantic.Field(default=None)
    """
    If enabled, clients are able to add legacy RO grants.
    """

    allow_legacy_tokeninfo_endpoint: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the legacy `/tokeninfo` endpoint is enabled for your account (true) or unavailable (false).
    """

    enable_legacy_profile: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether ID tokens and the userinfo endpoint includes a complete user profile (true) or only OpenID Connect claims (false).
    """

    enable_idtoken_api_2: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="enable_idtoken_api2")
    ] = pydantic.Field(default=None)
    """
    Whether ID tokens can be used to authorize some types of requests to API v2 (true) not not (false).
    """

    enable_public_signup_user_exists_error: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the public sign up process shows a user_exists error (true) or a generic error (false) if the user already exists.
    """

    enable_sso: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether users are prompted to confirm log in before SSO redirection (false) or are not prompted (true).
    """

    allow_changing_enable_sso: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the `enable_sso` setting can be changed (true) or not (false).
    """

    disable_clickjack_protection_headers: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether classic Universal Login prompts include additional security headers to prevent clickjacking (true) or no safeguard (false).
    """

    no_disclose_enterprise_connections: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Do not Publish Enterprise Connections Information with IdP domains on the lock configuration file.
    """

    enforce_client_authentication_on_passwordless_start: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Enforce client authentication for passwordless start.
    """

    enable_adfs_waad_email_verification: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Enables the email verification flow during login for Azure AD and ADFS connections
    """

    revoke_refresh_token_grant: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Delete underlying grant when a Refresh Token is revoked via the Authentication API.
    """

    dashboard_log_streams_next: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Enables beta access to log streaming changes
    """

    dashboard_insights_view: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Enables new insights activity page view
    """

    disable_fields_map_fix: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Disables SAML fields map fix for bad mappings with repeated attributes
    """

    mfa_show_factor_list_on_enrollment: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Used to allow users to pick what factor to enroll of the available MFA factors.
    """

    remove_alg_from_jwks: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Removes alg property from jwks .well-known endpoint
    """

    improved_signup_bot_detection_in_classic: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Improves bot detection during signup in classic universal login
    """

    genai_trial: typing.Optional[bool] = pydantic.Field(default=None)
    """
    This tenant signed up for the Auth4GenAI trail
    """

    enable_dynamic_client_registration: typing.Optional[bool] = pydantic.Field(default=False)
    """
    Whether third-party developers can <a href="https://auth0.com/docs/api-auth/dynamic-client-registration">dynamically register</a> applications for your APIs (true) or not (false). This flag enables dynamic client registration.
    """

    disable_management_api_sms_obfuscation: typing.Optional[bool] = pydantic.Field(default=True)
    """
    If true, SMS phone numbers will not be obfuscated in Management API GET calls.
    """

    trust_azure_adfs_email_verified_connection_property: typing.Optional[bool] = pydantic.Field(default=False)
    """
    Changes email_verified behavior for Azure AD/ADFS connections when enabled. Sets email_verified to false otherwise.
    """

    custom_domains_provisioning: typing.Optional[bool] = pydantic.Field(default=False)
    """
    If true, custom domains feature will be enabled for tenant.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
