# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class TenantSettingsPasswordPage(UniversalBaseModel):
    """
    Change Password page customization.
    """

    enabled: typing.Optional[bool] = pydantic.Field(default=False)
    """
    Whether to use the custom change password HTML (true) or the default Auth0 page (false). Default is to use the Auth0 page.
    """

    html: typing.Optional[str] = pydantic.Field(default="")
    """
    Custom change password HTML (<a href='https://github.com/Shopify/liquid/wiki/Liquid-for-Designers'>Liquid syntax</a> supported).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
