# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class TokenQuotaClientCredentials(UniversalBaseModel):
    """
    The token quota configuration
    """

    enforce: typing.Optional[bool] = pydantic.Field(default=None)
    """
    If enabled, the quota will be enforced and requests in excess of the quota will fail. If disabled, the quota will not be enforced, but notifications for requests exceeding the quota will be available in logs.
    """

    per_day: typing.Optional[int] = pydantic.Field(default=None)
    """
    Maximum number of issued tokens per day
    """

    per_hour: typing.Optional[int] = pydantic.Field(default=None)
    """
    Maximum number of issued tokens per hour
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
