# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .action_build_status_enum import ActionBuildStatusEnum
from .action_deployed_version import ActionDeployedVersion
from .action_secret_response import ActionSecretResponse
from .action_trigger import ActionTrigger
from .action_version_dependency import ActionVersionDependency
from .integration import Integration


class UpdateActionResponseContent(UniversalBaseModel):
    id: typing.Optional[str] = pydantic.Field(default="910b1053-577f-4d81-a8c8-020e7319a38a")
    """
    The unique ID of the action.
    """

    name: typing.Optional[str] = pydantic.Field(default="my-action")
    """
    The name of an action.
    """

    supported_triggers: typing.Optional[typing.List[ActionTrigger]] = pydantic.Field(default=None)
    """
    The list of triggers that this action supports. At this time, an action can only target a single trigger at a time.
    """

    all_changes_deployed: typing.Optional[bool] = pydantic.Field(default=False)
    """
    True if all of an Action's contents have been deployed.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when this action was created.
    """

    updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when this action was updated.
    """

    code: typing.Optional[str] = pydantic.Field(default="module.exports = () => {}")
    """
    The source code of the action.
    """

    dependencies: typing.Optional[typing.List[ActionVersionDependency]] = pydantic.Field(default=None)
    """
    The list of third party npm modules, and their versions, that this action depends on.
    """

    runtime: typing.Optional[str] = pydantic.Field(default="node22")
    """
    The Node runtime. For example: `node22`, defaults to `node22`
    """

    secrets: typing.Optional[typing.List[ActionSecretResponse]] = pydantic.Field(default=None)
    """
    The list of secrets that are included in an action or a version of an action.
    """

    deployed_version: typing.Optional[ActionDeployedVersion] = None
    installed_integration_id: typing.Optional[str] = pydantic.Field(default="7d2bc0c9-c0c2-433a-9f4e-86ef80270aad")
    """
    installed_integration_id is the fk reference to the InstalledIntegration entity.
    """

    integration: typing.Optional[Integration] = None
    status: typing.Optional[ActionBuildStatusEnum] = None
    built_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when this action was built successfully.
    """

    deploy: typing.Optional[bool] = pydantic.Field(default=False)
    """
    True if the action should be deployed after creation.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
