# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .connection_attributes import ConnectionAttributes
from .connection_authentication_methods import ConnectionAuthenticationMethods
from .connection_custom_scripts import ConnectionCustomScripts
from .connection_federated_connections_access_tokens import ConnectionFederatedConnectionsAccessTokens
from .connection_gateway_authentication import ConnectionGatewayAuthentication
from .connection_identifier_precedence_enum import ConnectionIdentifierPrecedenceEnum
from .connection_passkey_options import ConnectionPasskeyOptions
from .connection_password_complexity_options import ConnectionPasswordComplexityOptions
from .connection_password_dictionary_options import ConnectionPasswordDictionaryOptions
from .connection_password_history_options import ConnectionPasswordHistoryOptions
from .connection_password_no_personal_info_options import ConnectionPasswordNoPersonalInfoOptions
from .connection_password_policy_enum import ConnectionPasswordPolicyEnum
from .connection_set_user_root_attributes_enum import ConnectionSetUserRootAttributesEnum
from .connection_upstream_params import ConnectionUpstreamParams
from .connection_validation_options import ConnectionValidationOptions


class UpdateConnectionOptions(UniversalBaseModel):
    """
    The connection's options (depend on the connection strategy). To update these options, the `update:connections_options` scope must be present. To verify your changes, also include the `read:connections_options` scope. If this scope is not specified, you will not be able to review the updated object.
    """

    validation: typing.Optional[ConnectionValidationOptions] = None
    non_persistent_attrs: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    An array of user fields that should not be stored in the Auth0 database (https://auth0.com/docs/security/data-security/denylist)
    """

    precedence: typing.Optional[typing.List[ConnectionIdentifierPrecedenceEnum]] = pydantic.Field(default=None)
    """
    Order of precedence for attribute types. If the property is not specified, the default precedence of attributes will be used.
    """

    attributes: typing.Optional[ConnectionAttributes] = None
    enable_script_context: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Set to true to inject context into custom DB scripts (warning: cannot be disabled once enabled)
    """

    enabled_database_customization: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="enabledDatabaseCustomization")
    ] = pydantic.Field(default=None)
    """
    Set to true to use a legacy user store
    """

    import_mode: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Enable this if you have a legacy user store and you want to gradually migrate those users to the Auth0 user store
    """

    custom_scripts: typing_extensions.Annotated[
        typing.Optional[ConnectionCustomScripts], FieldMetadata(alias="customScripts")
    ] = None
    authentication_methods: typing.Optional[ConnectionAuthenticationMethods] = None
    passkey_options: typing.Optional[ConnectionPasskeyOptions] = None
    password_policy: typing_extensions.Annotated[
        typing.Optional[ConnectionPasswordPolicyEnum], FieldMetadata(alias="passwordPolicy")
    ] = None
    password_complexity_options: typing.Optional[ConnectionPasswordComplexityOptions] = None
    password_history: typing.Optional[ConnectionPasswordHistoryOptions] = None
    password_no_personal_info: typing.Optional[ConnectionPasswordNoPersonalInfoOptions] = None
    password_dictionary: typing.Optional[ConnectionPasswordDictionaryOptions] = None
    api_enable_users: typing.Optional[bool] = None
    basic_profile: typing.Optional[bool] = None
    ext_admin: typing.Optional[bool] = None
    ext_is_suspended: typing.Optional[bool] = None
    ext_agreed_terms: typing.Optional[bool] = None
    ext_groups: typing.Optional[bool] = None
    ext_assigned_plans: typing.Optional[bool] = None
    ext_profile: typing.Optional[bool] = None
    disable_self_service_change_password: typing.Optional[bool] = None
    upstream_params: typing.Optional[ConnectionUpstreamParams] = None
    set_user_root_attributes: typing.Optional[ConnectionSetUserRootAttributesEnum] = None
    gateway_authentication: typing.Optional[ConnectionGatewayAuthentication] = None
    federated_connections_access_tokens: typing.Optional[ConnectionFederatedConnectionsAccessTokens] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
