# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .custom_domain_status_filter_enum import CustomDomainStatusFilterEnum
from .custom_domain_type_enum import CustomDomainTypeEnum
from .domain_certificate import DomainCertificate
from .domain_metadata import DomainMetadata
from .domain_verification import DomainVerification


class UpdateCustomDomainResponseContent(UniversalBaseModel):
    custom_domain_id: str = pydantic.Field(default="cd_0000000000000001")
    """
    ID of the custom domain.
    """

    domain: str = pydantic.Field(default="login.mycompany.com")
    """
    Domain name.
    """

    primary: bool = pydantic.Field(default=False)
    """
    Whether this is a primary domain (true) or not (false).
    """

    status: CustomDomainStatusFilterEnum
    type: CustomDomainTypeEnum
    verification: DomainVerification
    custom_client_ip_header: typing.Optional[str] = pydantic.Field(default=None)
    """
    The HTTP header to fetch the client's IP address
    """

    tls_policy: typing.Optional[str] = pydantic.Field(default="recommended")
    """
    The TLS version policy
    """

    domain_metadata: typing.Optional[DomainMetadata] = None
    certificate: typing.Optional[DomainCertificate] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
