# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .hook_dependencies import HookDependencies


class UpdateHookResponseContent(UniversalBaseModel):
    trigger_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="triggerId")] = pydantic.Field(
        default=None
    )
    """
    Trigger ID
    """

    id: typing.Optional[str] = pydantic.Field(default="00001")
    """
    ID of this hook.
    """

    name: typing.Optional[str] = pydantic.Field(default="hook")
    """
    Name of this hook.
    """

    enabled: typing.Optional[bool] = pydantic.Field(default=True)
    """
    Whether this hook will be executed (true) or ignored (false).
    """

    script: typing.Optional[str] = pydantic.Field(
        default="module.exports = function(client, scope, audience, context, cb) cb(null, access_token); };"
    )
    """
    Code to be executed when this hook runs.
    """

    dependencies: typing.Optional[HookDependencies] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
