# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .user_attribute_profile_oidc_mapping import UserAttributeProfileOidcMapping
from .user_attribute_profile_saml_mapping import UserAttributeProfileSamlMapping
from .user_attribute_profile_strategy_overrides import UserAttributeProfileStrategyOverrides


class UserAttributeProfileUserAttributeAdditionalProperties(UniversalBaseModel):
    description: str = pydantic.Field()
    """
    Description of this attribute
    """

    label: str = pydantic.Field()
    """
    Display label for this attribute
    """

    profile_required: bool = pydantic.Field()
    """
    Whether this attribute is required in the profile
    """

    auth_0_mapping: typing_extensions.Annotated[str, FieldMetadata(alias="auth0_mapping")] = pydantic.Field()
    """
    Auth0 mapping for this attribute
    """

    oidc_mapping: typing.Optional[UserAttributeProfileOidcMapping] = None
    saml_mapping: typing.Optional[UserAttributeProfileSamlMapping] = None
    scim_mapping: typing.Optional[str] = pydantic.Field(default=None)
    """
    SCIM mapping for this attribute
    """

    strategy_overrides: typing.Optional[UserAttributeProfileStrategyOverrides] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
