# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class UserGrant(UniversalBaseModel):
    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the grant.
    """

    client_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="clientID")] = pydantic.Field(
        default=None
    )
    """
    ID of the client.
    """

    user_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the user.
    """

    audience: typing.Optional[str] = pydantic.Field(default=None)
    """
    Audience of the grant.
    """

    scope: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Scopes included in this grant.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
