# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .user_id import UserId
from .user_profile_data import UserProfileData


class UserIdentity(UniversalBaseModel):
    connection: str = pydantic.Field(default="twitter")
    """
    Connection name of this identity.
    """

    user_id: UserId
    provider: str = pydantic.Field(default="twitter")
    """
    Type of identity provider.
    """

    profile_data: typing_extensions.Annotated[typing.Optional[UserProfileData], FieldMetadata(alias="profileData")] = (
        None
    )
    is_social: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="isSocial")] = pydantic.Field(
        default=None
    )
    """
    Whether the identity provider is a social provider (true) or not (false).
    """

    access_token: typing.Optional[str] = pydantic.Field(default=None)
    """
    IDP access token returned if scope `read:user_idp_tokens` is defined.
    """

    access_token_secret: typing.Optional[str] = pydantic.Field(default=None)
    """
    IDP access token secret returned only if `scope read:user_idp_tokens` is defined.
    """

    refresh_token: typing.Optional[str] = pydantic.Field(default=None)
    """
    IDP refresh token returned only if scope `read:user_idp_tokens` is defined.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
