# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .user_identity_provider_enum import UserIdentityProviderEnum
from .user_profile_data import UserProfileData


class UserIdentitySchema(UniversalBaseModel):
    connection: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the connection containing this identity.
    """

    user_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique identifier of the user user for this identity.
    """

    provider: typing.Optional[UserIdentityProviderEnum] = None
    is_social: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="isSocial")] = pydantic.Field(
        default=None
    )
    """
    Whether this identity is from a social provider (true) or not (false).
    """

    access_token: typing.Optional[str] = pydantic.Field(default=None)
    """
    IDP access token returned only if scope read:user_idp_tokens is defined.
    """

    access_token_secret: typing.Optional[str] = pydantic.Field(default=None)
    """
    IDP access token secret returned only if scope read:user_idp_tokens is defined.
    """

    refresh_token: typing.Optional[str] = pydantic.Field(default=None)
    """
    IDP refresh token returned only if scope read:user_idp_tokens is defined.
    """

    profile_data: typing_extensions.Annotated[typing.Optional[UserProfileData], FieldMetadata(alias="profileData")] = (
        None
    )

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
