# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class UserPermissionSchema(UniversalBaseModel):
    resource_server_identifier: typing.Optional[str] = pydantic.Field(default=None)
    """
    Resource server (API) identifier that this permission is for.
    """

    permission_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of this permission.
    """

    resource_server_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Resource server (API) name this permission is for.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of this permission.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
