# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class UserProfileData(UniversalBaseModel):
    email: typing.Optional[str] = pydantic.Field(default=None)
    """
    Email address of this user.
    """

    email_verified: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this email address is verified (true) or unverified (false).
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of this user.
    """

    username: typing.Optional[str] = pydantic.Field(default="johndoe")
    """
    Username of this user.
    """

    given_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Given name/first name/forename of this user.
    """

    phone_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    Phone number for this user.
    """

    phone_verified: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this phone number is verified (true) or unverified (false).
    """

    family_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Family name/last name/surname of this user.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
