# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .user_enrollment_auth_method_enum import UserEnrollmentAuthMethodEnum
from .user_enrollment_status_enum import UserEnrollmentStatusEnum


class UsersEnrollment(UniversalBaseModel):
    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of this enrollment.
    """

    status: typing.Optional[UserEnrollmentStatusEnum] = None
    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    Type of enrollment.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of enrollment (usually phone number).
    """

    identifier: typing.Optional[str] = pydantic.Field(default=None)
    """
    Device identifier (usually phone identifier) of this enrollment.
    """

    phone_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    Phone number for this enrollment.
    """

    auth_method: typing.Optional[UserEnrollmentAuthMethodEnum] = None
    enrolled_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Start date and time of this enrollment.
    """

    last_auth: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Last authentication date and time of this enrollment.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
