# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.create_user_attribute_profile_response_content import CreateUserAttributeProfileResponseContent
from ..types.get_user_attribute_profile_response_content import GetUserAttributeProfileResponseContent
from ..types.get_user_attribute_profile_template_response_content import GetUserAttributeProfileTemplateResponseContent
from ..types.list_user_attribute_profile_template_response_content import (
    ListUserAttributeProfileTemplateResponseContent,
)
from ..types.list_user_attribute_profiles_paginated_response_content import (
    ListUserAttributeProfilesPaginatedResponseContent,
)
from ..types.update_user_attribute_profile_response_content import UpdateUserAttributeProfileResponseContent
from ..types.user_attribute_profile import UserAttributeProfile
from ..types.user_attribute_profile_name import UserAttributeProfileName
from ..types.user_attribute_profile_patch_user_id import UserAttributeProfilePatchUserId
from ..types.user_attribute_profile_user_attributes import UserAttributeProfileUserAttributes
from ..types.user_attribute_profile_user_id import UserAttributeProfileUserId
from .raw_client import AsyncRawUserAttributeProfilesClient, RawUserAttributeProfilesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class UserAttributeProfilesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawUserAttributeProfilesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawUserAttributeProfilesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawUserAttributeProfilesClient
        """
        return self._raw_client

    def list(
        self,
        *,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[UserAttributeProfile, ListUserAttributeProfilesPaginatedResponseContent]:
        """
        Retrieve a list of User Attribute Profiles. This endpoint supports Checkpoint pagination.

        Parameters
        ----------
        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results per page. Defaults to 5.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[UserAttributeProfile, ListUserAttributeProfilesPaginatedResponseContent]
            User Attribute Profiles successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.user_attribute_profiles.list(
            from_="from",
            take=1,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(from_=from_, take=take, request_options=request_options)

    def create(
        self,
        *,
        name: UserAttributeProfileName,
        user_attributes: UserAttributeProfileUserAttributes,
        user_id: typing.Optional[UserAttributeProfileUserId] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateUserAttributeProfileResponseContent:
        """
        Retrieve details about a single User Attribute Profile specified by ID.

        Parameters
        ----------
        name : UserAttributeProfileName

        user_attributes : UserAttributeProfileUserAttributes

        user_id : typing.Optional[UserAttributeProfileUserId]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateUserAttributeProfileResponseContent
            User attribute successfully created.

        Examples
        --------
        from auth0 import Auth0, UserAttributeProfileUserAttributeAdditionalProperties

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.user_attribute_profiles.create(
            name="name",
            user_attributes={
                "key": UserAttributeProfileUserAttributeAdditionalProperties(
                    description="description",
                    label="label",
                    profile_required=True,
                    auth_0_mapping="auth0_mapping",
                )
            },
        )
        """
        _response = self._raw_client.create(
            name=name, user_attributes=user_attributes, user_id=user_id, request_options=request_options
        )
        return _response.data

    def list_templates(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ListUserAttributeProfileTemplateResponseContent:
        """
        Retrieve a list of User Attribute Profile Templates.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListUserAttributeProfileTemplateResponseContent
            User Attribute Profile Templates successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.user_attribute_profiles.list_templates()
        """
        _response = self._raw_client.list_templates(request_options=request_options)
        return _response.data

    def get_template(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetUserAttributeProfileTemplateResponseContent:
        """
        Retrieve a User Attribute Profile Template.

        Parameters
        ----------
        id : str
            ID of the user-attribute-profile-template to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetUserAttributeProfileTemplateResponseContent
            User Attribute Profile Template successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.user_attribute_profiles.get_template(
            id="id",
        )
        """
        _response = self._raw_client.get_template(id, request_options=request_options)
        return _response.data

    def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetUserAttributeProfileResponseContent:
        """
        Retrieve details about a single User Attribute Profile specified by ID.

        Parameters
        ----------
        id : str
            ID of the user-attribute-profile to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetUserAttributeProfileResponseContent
            Record for existing user attribute profile.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.user_attribute_profiles.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a single User Attribute Profile specified by ID.

        Parameters
        ----------
        id : str
            ID of the user-attribute-profile to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.user_attribute_profiles.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        name: typing.Optional[UserAttributeProfileName] = OMIT,
        user_id: typing.Optional[UserAttributeProfilePatchUserId] = OMIT,
        user_attributes: typing.Optional[UserAttributeProfileUserAttributes] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateUserAttributeProfileResponseContent:
        """
        Update the details of a specific User attribute profile, such as name, user_id and user_attributes.

        Parameters
        ----------
        id : str
            ID of the user attribute profile to update.

        name : typing.Optional[UserAttributeProfileName]

        user_id : typing.Optional[UserAttributeProfilePatchUserId]

        user_attributes : typing.Optional[UserAttributeProfileUserAttributes]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateUserAttributeProfileResponseContent
            User attribute profile successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.user_attribute_profiles.update(
            id="id",
        )
        """
        _response = self._raw_client.update(
            id, name=name, user_id=user_id, user_attributes=user_attributes, request_options=request_options
        )
        return _response.data


class AsyncUserAttributeProfilesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawUserAttributeProfilesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawUserAttributeProfilesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawUserAttributeProfilesClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[UserAttributeProfile, ListUserAttributeProfilesPaginatedResponseContent]:
        """
        Retrieve a list of User Attribute Profiles. This endpoint supports Checkpoint pagination.

        Parameters
        ----------
        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results per page. Defaults to 5.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[UserAttributeProfile, ListUserAttributeProfilesPaginatedResponseContent]
            User Attribute Profiles successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.user_attribute_profiles.list(
                from_="from",
                take=1,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(from_=from_, take=take, request_options=request_options)

    async def create(
        self,
        *,
        name: UserAttributeProfileName,
        user_attributes: UserAttributeProfileUserAttributes,
        user_id: typing.Optional[UserAttributeProfileUserId] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateUserAttributeProfileResponseContent:
        """
        Retrieve details about a single User Attribute Profile specified by ID.

        Parameters
        ----------
        name : UserAttributeProfileName

        user_attributes : UserAttributeProfileUserAttributes

        user_id : typing.Optional[UserAttributeProfileUserId]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateUserAttributeProfileResponseContent
            User attribute successfully created.

        Examples
        --------
        import asyncio

        from auth0 import (
            AsyncAuth0,
            UserAttributeProfileUserAttributeAdditionalProperties,
        )

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.user_attribute_profiles.create(
                name="name",
                user_attributes={
                    "key": UserAttributeProfileUserAttributeAdditionalProperties(
                        description="description",
                        label="label",
                        profile_required=True,
                        auth_0_mapping="auth0_mapping",
                    )
                },
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name, user_attributes=user_attributes, user_id=user_id, request_options=request_options
        )
        return _response.data

    async def list_templates(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ListUserAttributeProfileTemplateResponseContent:
        """
        Retrieve a list of User Attribute Profile Templates.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListUserAttributeProfileTemplateResponseContent
            User Attribute Profile Templates successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.user_attribute_profiles.list_templates()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_templates(request_options=request_options)
        return _response.data

    async def get_template(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetUserAttributeProfileTemplateResponseContent:
        """
        Retrieve a User Attribute Profile Template.

        Parameters
        ----------
        id : str
            ID of the user-attribute-profile-template to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetUserAttributeProfileTemplateResponseContent
            User Attribute Profile Template successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.user_attribute_profiles.get_template(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_template(id, request_options=request_options)
        return _response.data

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetUserAttributeProfileResponseContent:
        """
        Retrieve details about a single User Attribute Profile specified by ID.

        Parameters
        ----------
        id : str
            ID of the user-attribute-profile to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetUserAttributeProfileResponseContent
            Record for existing user attribute profile.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.user_attribute_profiles.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a single User Attribute Profile specified by ID.

        Parameters
        ----------
        id : str
            ID of the user-attribute-profile to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.user_attribute_profiles.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        name: typing.Optional[UserAttributeProfileName] = OMIT,
        user_id: typing.Optional[UserAttributeProfilePatchUserId] = OMIT,
        user_attributes: typing.Optional[UserAttributeProfileUserAttributes] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateUserAttributeProfileResponseContent:
        """
        Update the details of a specific User attribute profile, such as name, user_id and user_attributes.

        Parameters
        ----------
        id : str
            ID of the user attribute profile to update.

        name : typing.Optional[UserAttributeProfileName]

        user_id : typing.Optional[UserAttributeProfilePatchUserId]

        user_attributes : typing.Optional[UserAttributeProfileUserAttributes]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateUserAttributeProfileResponseContent
            User attribute profile successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.user_attribute_profiles.update(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id, name=name, user_id=user_id, user_attributes=user_attributes, request_options=request_options
        )
        return _response.data
