# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.list_user_blocks_by_identifier_response_content import ListUserBlocksByIdentifierResponseContent
from ..types.list_user_blocks_response_content import ListUserBlocksResponseContent
from .raw_client import AsyncRawUserBlocksClient, RawUserBlocksClient


class UserBlocksClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawUserBlocksClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawUserBlocksClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawUserBlocksClient
        """
        return self._raw_client

    def list_by_identifier(
        self,
        *,
        identifier: str,
        consider_brute_force_enablement: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListUserBlocksByIdentifierResponseContent:
        """
        Retrieve details of all <a href="https://auth0.com/docs/secure/attack-protection/brute-force-protection">Brute-force Protection</a> blocks for a user with the given identifier (username, phone number, or email).

        Parameters
        ----------
        identifier : str
            Should be any of a username, phone number, or email.

        consider_brute_force_enablement : typing.Optional[bool]

                      If true and Brute Force Protection is enabled and configured to block logins, will return a list of blocked IP addresses.
                      If true and Brute Force Protection is disabled, will return an empty list.


        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListUserBlocksByIdentifierResponseContent
            User successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.user_blocks.list_by_identifier(
            identifier="identifier",
            consider_brute_force_enablement=True,
        )
        """
        _response = self._raw_client.list_by_identifier(
            identifier=identifier,
            consider_brute_force_enablement=consider_brute_force_enablement,
            request_options=request_options,
        )
        return _response.data

    def delete_by_identifier(self, *, identifier: str, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Remove all <a href="https://auth0.com/docs/secure/attack-protection/brute-force-protection">Brute-force Protection</a> blocks for the user with the given identifier (username, phone number, or email).

        Note: This endpoint does not unblock users that were <a href="https://auth0.com/docs/user-profile#block-and-unblock-a-user">blocked by a tenant administrator</a>.

        Parameters
        ----------
        identifier : str
            Should be any of a username, phone number, or email.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.user_blocks.delete_by_identifier(
            identifier="identifier",
        )
        """
        _response = self._raw_client.delete_by_identifier(identifier=identifier, request_options=request_options)
        return _response.data

    def list(
        self,
        id: str,
        *,
        consider_brute_force_enablement: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListUserBlocksResponseContent:
        """
        Retrieve details of all <a href="https://auth0.com/docs/secure/attack-protection/brute-force-protection">Brute-force Protection</a> blocks for the user with the given ID.

        Parameters
        ----------
        id : str
            user_id of the user blocks to retrieve.

        consider_brute_force_enablement : typing.Optional[bool]

                      If true and Brute Force Protection is enabled and configured to block logins, will return a list of blocked IP addresses.
                      If true and Brute Force Protection is disabled, will return an empty list.


        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListUserBlocksResponseContent
            User block successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.user_blocks.list(
            id="id",
            consider_brute_force_enablement=True,
        )
        """
        _response = self._raw_client.list(
            id, consider_brute_force_enablement=consider_brute_force_enablement, request_options=request_options
        )
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Remove all <a href="https://auth0.com/docs/secure/attack-protection/brute-force-protection">Brute-force Protection</a> blocks for the user with the given ID.

        Note: This endpoint does not unblock users that were <a href="https://auth0.com/docs/user-profile#block-and-unblock-a-user">blocked by a tenant administrator</a>.

        Parameters
        ----------
        id : str
            The user_id of the user to update.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.user_blocks.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data


class AsyncUserBlocksClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawUserBlocksClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawUserBlocksClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawUserBlocksClient
        """
        return self._raw_client

    async def list_by_identifier(
        self,
        *,
        identifier: str,
        consider_brute_force_enablement: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListUserBlocksByIdentifierResponseContent:
        """
        Retrieve details of all <a href="https://auth0.com/docs/secure/attack-protection/brute-force-protection">Brute-force Protection</a> blocks for a user with the given identifier (username, phone number, or email).

        Parameters
        ----------
        identifier : str
            Should be any of a username, phone number, or email.

        consider_brute_force_enablement : typing.Optional[bool]

                      If true and Brute Force Protection is enabled and configured to block logins, will return a list of blocked IP addresses.
                      If true and Brute Force Protection is disabled, will return an empty list.


        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListUserBlocksByIdentifierResponseContent
            User successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.user_blocks.list_by_identifier(
                identifier="identifier",
                consider_brute_force_enablement=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_by_identifier(
            identifier=identifier,
            consider_brute_force_enablement=consider_brute_force_enablement,
            request_options=request_options,
        )
        return _response.data

    async def delete_by_identifier(
        self, *, identifier: str, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Remove all <a href="https://auth0.com/docs/secure/attack-protection/brute-force-protection">Brute-force Protection</a> blocks for the user with the given identifier (username, phone number, or email).

        Note: This endpoint does not unblock users that were <a href="https://auth0.com/docs/user-profile#block-and-unblock-a-user">blocked by a tenant administrator</a>.

        Parameters
        ----------
        identifier : str
            Should be any of a username, phone number, or email.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.user_blocks.delete_by_identifier(
                identifier="identifier",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_by_identifier(identifier=identifier, request_options=request_options)
        return _response.data

    async def list(
        self,
        id: str,
        *,
        consider_brute_force_enablement: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListUserBlocksResponseContent:
        """
        Retrieve details of all <a href="https://auth0.com/docs/secure/attack-protection/brute-force-protection">Brute-force Protection</a> blocks for the user with the given ID.

        Parameters
        ----------
        id : str
            user_id of the user blocks to retrieve.

        consider_brute_force_enablement : typing.Optional[bool]

                      If true and Brute Force Protection is enabled and configured to block logins, will return a list of blocked IP addresses.
                      If true and Brute Force Protection is disabled, will return an empty list.


        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListUserBlocksResponseContent
            User block successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.user_blocks.list(
                id="id",
                consider_brute_force_enablement=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            id, consider_brute_force_enablement=consider_brute_force_enablement, request_options=request_options
        )
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Remove all <a href="https://auth0.com/docs/secure/attack-protection/brute-force-protection">Brute-force Protection</a> blocks for the user with the given ID.

        Note: This endpoint does not unblock users that were <a href="https://auth0.com/docs/user-profile#block-and-unblock-a-user">blocked by a tenant administrator</a>.

        Parameters
        ----------
        id : str
            The user_id of the user to update.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.user_blocks.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data
