# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.list_user_grants_offset_paginated_response_content import ListUserGrantsOffsetPaginatedResponseContent
from ..types.user_grant import UserGrant
from .raw_client import AsyncRawUserGrantsClient, RawUserGrantsClient


class UserGrantsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawUserGrantsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawUserGrantsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawUserGrantsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        per_page: typing.Optional[int] = 50,
        page: typing.Optional[int] = 0,
        include_totals: typing.Optional[bool] = True,
        user_id: typing.Optional[str] = None,
        client_id: typing.Optional[str] = None,
        audience: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[UserGrant, ListUserGrantsOffsetPaginatedResponseContent]:
        """
        Retrieve the <a href="https://auth0.com/docs/api-auth/which-oauth-flow-to-use">grants</a> associated with your account.

        Parameters
        ----------
        per_page : typing.Optional[int]
            Number of results per page.

        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        user_id : typing.Optional[str]
            user_id of the grants to retrieve.

        client_id : typing.Optional[str]
            client_id of the grants to retrieve.

        audience : typing.Optional[str]
            audience of the grants to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[UserGrant, ListUserGrantsOffsetPaginatedResponseContent]
            Grants successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.user_grants.list(
            per_page=1,
            page=1,
            include_totals=True,
            user_id="user_id",
            client_id="client_id",
            audience="audience",
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            per_page=per_page,
            page=page,
            include_totals=include_totals,
            user_id=user_id,
            client_id=client_id,
            audience=audience,
            request_options=request_options,
        )

    def delete_by_user_id(self, *, user_id: str, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a grant associated with your account.

        Parameters
        ----------
        user_id : str
            user_id of the grant to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.user_grants.delete_by_user_id(
            user_id="user_id",
        )
        """
        _response = self._raw_client.delete_by_user_id(user_id=user_id, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a grant associated with your account.

        Parameters
        ----------
        id : str
            ID of the grant to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.user_grants.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data


class AsyncUserGrantsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawUserGrantsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawUserGrantsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawUserGrantsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        per_page: typing.Optional[int] = 50,
        page: typing.Optional[int] = 0,
        include_totals: typing.Optional[bool] = True,
        user_id: typing.Optional[str] = None,
        client_id: typing.Optional[str] = None,
        audience: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[UserGrant, ListUserGrantsOffsetPaginatedResponseContent]:
        """
        Retrieve the <a href="https://auth0.com/docs/api-auth/which-oauth-flow-to-use">grants</a> associated with your account.

        Parameters
        ----------
        per_page : typing.Optional[int]
            Number of results per page.

        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        user_id : typing.Optional[str]
            user_id of the grants to retrieve.

        client_id : typing.Optional[str]
            client_id of the grants to retrieve.

        audience : typing.Optional[str]
            audience of the grants to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[UserGrant, ListUserGrantsOffsetPaginatedResponseContent]
            Grants successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.user_grants.list(
                per_page=1,
                page=1,
                include_totals=True,
                user_id="user_id",
                client_id="client_id",
                audience="audience",
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            per_page=per_page,
            page=page,
            include_totals=include_totals,
            user_id=user_id,
            client_id=client_id,
            audience=audience,
            request_options=request_options,
        )

    async def delete_by_user_id(self, *, user_id: str, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a grant associated with your account.

        Parameters
        ----------
        user_id : str
            user_id of the grant to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.user_grants.delete_by_user_id(
                user_id="user_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_by_user_id(user_id=user_id, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a grant associated with your account.

        Parameters
        ----------
        id : str
            ID of the grant to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.user_grants.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data
