# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pagination import AsyncPager, SyncPager
from ...core.request_options import RequestOptions
from ...types.create_user_authentication_method_response_content import CreateUserAuthenticationMethodResponseContent
from ...types.created_user_authentication_method_type_enum import CreatedUserAuthenticationMethodTypeEnum
from ...types.get_user_authentication_method_response_content import GetUserAuthenticationMethodResponseContent
from ...types.list_user_authentication_methods_offset_paginated_response_content import (
    ListUserAuthenticationMethodsOffsetPaginatedResponseContent,
)
from ...types.preferred_authentication_method_enum import PreferredAuthenticationMethodEnum
from ...types.set_user_authentication_method_response_content import SetUserAuthenticationMethodResponseContent
from ...types.set_user_authentication_methods_request_content import SetUserAuthenticationMethodsRequestContent
from ...types.update_user_authentication_method_response_content import UpdateUserAuthenticationMethodResponseContent
from ...types.user_authentication_method import UserAuthenticationMethod
from .raw_client import AsyncRawAuthenticationMethodsClient, RawAuthenticationMethodsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AuthenticationMethodsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAuthenticationMethodsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAuthenticationMethodsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAuthenticationMethodsClient
        """
        return self._raw_client

    def list(
        self,
        id: str,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[UserAuthenticationMethod, ListUserAuthenticationMethodsOffsetPaginatedResponseContent]:
        """
        Retrieve detailed list of authentication methods associated with a specified user.

        Parameters
        ----------
        id : str
            The ID of the user in question.

        page : typing.Optional[int]
            Page index of the results to return. First page is 0. Default is 0.

        per_page : typing.Optional[int]
            Number of results per page. Default is 50.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[UserAuthenticationMethod, ListUserAuthenticationMethodsOffsetPaginatedResponseContent]
            The authentication methods for the user were retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.users.authentication_methods.list(
            id="id",
            page=1,
            per_page=1,
            include_totals=True,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            id, page=page, per_page=per_page, include_totals=include_totals, request_options=request_options
        )

    def create(
        self,
        id: str,
        *,
        type: CreatedUserAuthenticationMethodTypeEnum,
        name: typing.Optional[str] = OMIT,
        totp_secret: typing.Optional[str] = OMIT,
        phone_number: typing.Optional[str] = OMIT,
        email: typing.Optional[str] = OMIT,
        preferred_authentication_method: typing.Optional[PreferredAuthenticationMethodEnum] = OMIT,
        key_id: typing.Optional[str] = OMIT,
        public_key: typing.Optional[str] = OMIT,
        relying_party_identifier: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateUserAuthenticationMethodResponseContent:
        """
        Create an authentication method. Authentication methods created via this endpoint will be auto confirmed and should already have verification completed.

        Parameters
        ----------
        id : str
            The ID of the user to whom the new authentication method will be assigned.

        type : CreatedUserAuthenticationMethodTypeEnum

        name : typing.Optional[str]
            A human-readable label to identify the authentication method.

        totp_secret : typing.Optional[str]
            Base32 encoded secret for TOTP generation.

        phone_number : typing.Optional[str]
            Applies to phone authentication methods only. The destination phone number used to send verification codes via text and voice.

        email : typing.Optional[str]
            Applies to email authentication methods only. The email address used to send verification messages.

        preferred_authentication_method : typing.Optional[PreferredAuthenticationMethodEnum]

        key_id : typing.Optional[str]
            Applies to webauthn authentication methods only. The id of the credential.

        public_key : typing.Optional[str]
            Applies to webauthn authentication methods only. The public key, which is encoded as base64.

        relying_party_identifier : typing.Optional[str]
            Applies to webauthn authentication methods only. The relying party identifier.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateUserAuthenticationMethodResponseContent
            Authentication method created.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.users.authentication_methods.create(
            id="id",
            type="phone",
        )
        """
        _response = self._raw_client.create(
            id,
            type=type,
            name=name,
            totp_secret=totp_secret,
            phone_number=phone_number,
            email=email,
            preferred_authentication_method=preferred_authentication_method,
            key_id=key_id,
            public_key=public_key,
            relying_party_identifier=relying_party_identifier,
            request_options=request_options,
        )
        return _response.data

    def set(
        self,
        id: str,
        *,
        request: SetUserAuthenticationMethodsRequestContent,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[SetUserAuthenticationMethodResponseContent]:
        """
        Replace the specified user <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors"> authentication methods</a> with supplied values.

            <b>Note</b>: Authentication methods supplied through this action do not iterate on existing methods. Instead, any methods passed will overwrite the user&#8217s existing settings.

        Parameters
        ----------
        id : str
            The ID of the user in question.

        request : SetUserAuthenticationMethodsRequestContent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[SetUserAuthenticationMethodResponseContent]
            All authentication methods successfully updated.

        Examples
        --------
        from auth0 import Auth0, SetUserAuthenticationMethods

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.users.authentication_methods.set(
            id="id",
            request=[
                SetUserAuthenticationMethods(
                    type="phone",
                )
            ],
        )
        """
        _response = self._raw_client.set(id, request=request, request_options=request_options)
        return _response.data

    def delete_all(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Remove all authentication methods (i.e., enrolled MFA factors) from the specified user account. This action cannot be undone.

        Parameters
        ----------
        id : str
            The ID of the user in question.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.users.authentication_methods.delete_all(
            id="id",
        )
        """
        _response = self._raw_client.delete_all(id, request_options=request_options)
        return _response.data

    def get(
        self, id: str, authentication_method_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetUserAuthenticationMethodResponseContent:
        """
        Parameters
        ----------
        id : str
            The ID of the user in question.

        authentication_method_id : str
            The ID of the authentication methods in question.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetUserAuthenticationMethodResponseContent
            Authentication method retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.users.authentication_methods.get(
            id="id",
            authentication_method_id="authentication_method_id",
        )
        """
        _response = self._raw_client.get(id, authentication_method_id, request_options=request_options)
        return _response.data

    def delete(
        self, id: str, authentication_method_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Remove the authentication method with the given ID from the specified user. For more information, review <a href="https://auth0.com/docs/secure/multi-factor-authentication/manage-mfa-auth0-apis/manage-authentication-methods-with-management-api">Manage Authentication Methods with Management API</a>.

        Parameters
        ----------
        id : str
            The ID of the user in question.

        authentication_method_id : str
            The ID of the authentication method to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.users.authentication_methods.delete(
            id="id",
            authentication_method_id="authentication_method_id",
        )
        """
        _response = self._raw_client.delete(id, authentication_method_id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        authentication_method_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        preferred_authentication_method: typing.Optional[PreferredAuthenticationMethodEnum] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateUserAuthenticationMethodResponseContent:
        """
        Modify the authentication method with the given ID from the specified user. For more information, review <a href="https://auth0.com/docs/secure/multi-factor-authentication/manage-mfa-auth0-apis/manage-authentication-methods-with-management-api">Manage Authentication Methods with Management API</a>.

        Parameters
        ----------
        id : str
            The ID of the user in question.

        authentication_method_id : str
            The ID of the authentication method to update.

        name : typing.Optional[str]
            A human-readable label to identify the authentication method.

        preferred_authentication_method : typing.Optional[PreferredAuthenticationMethodEnum]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateUserAuthenticationMethodResponseContent
            Authentication method updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.users.authentication_methods.update(
            id="id",
            authentication_method_id="authentication_method_id",
        )
        """
        _response = self._raw_client.update(
            id,
            authentication_method_id,
            name=name,
            preferred_authentication_method=preferred_authentication_method,
            request_options=request_options,
        )
        return _response.data


class AsyncAuthenticationMethodsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAuthenticationMethodsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAuthenticationMethodsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAuthenticationMethodsClient
        """
        return self._raw_client

    async def list(
        self,
        id: str,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[UserAuthenticationMethod, ListUserAuthenticationMethodsOffsetPaginatedResponseContent]:
        """
        Retrieve detailed list of authentication methods associated with a specified user.

        Parameters
        ----------
        id : str
            The ID of the user in question.

        page : typing.Optional[int]
            Page index of the results to return. First page is 0. Default is 0.

        per_page : typing.Optional[int]
            Number of results per page. Default is 50.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[UserAuthenticationMethod, ListUserAuthenticationMethodsOffsetPaginatedResponseContent]
            The authentication methods for the user were retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.users.authentication_methods.list(
                id="id",
                page=1,
                per_page=1,
                include_totals=True,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            id, page=page, per_page=per_page, include_totals=include_totals, request_options=request_options
        )

    async def create(
        self,
        id: str,
        *,
        type: CreatedUserAuthenticationMethodTypeEnum,
        name: typing.Optional[str] = OMIT,
        totp_secret: typing.Optional[str] = OMIT,
        phone_number: typing.Optional[str] = OMIT,
        email: typing.Optional[str] = OMIT,
        preferred_authentication_method: typing.Optional[PreferredAuthenticationMethodEnum] = OMIT,
        key_id: typing.Optional[str] = OMIT,
        public_key: typing.Optional[str] = OMIT,
        relying_party_identifier: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateUserAuthenticationMethodResponseContent:
        """
        Create an authentication method. Authentication methods created via this endpoint will be auto confirmed and should already have verification completed.

        Parameters
        ----------
        id : str
            The ID of the user to whom the new authentication method will be assigned.

        type : CreatedUserAuthenticationMethodTypeEnum

        name : typing.Optional[str]
            A human-readable label to identify the authentication method.

        totp_secret : typing.Optional[str]
            Base32 encoded secret for TOTP generation.

        phone_number : typing.Optional[str]
            Applies to phone authentication methods only. The destination phone number used to send verification codes via text and voice.

        email : typing.Optional[str]
            Applies to email authentication methods only. The email address used to send verification messages.

        preferred_authentication_method : typing.Optional[PreferredAuthenticationMethodEnum]

        key_id : typing.Optional[str]
            Applies to webauthn authentication methods only. The id of the credential.

        public_key : typing.Optional[str]
            Applies to webauthn authentication methods only. The public key, which is encoded as base64.

        relying_party_identifier : typing.Optional[str]
            Applies to webauthn authentication methods only. The relying party identifier.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateUserAuthenticationMethodResponseContent
            Authentication method created.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.users.authentication_methods.create(
                id="id",
                type="phone",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            id,
            type=type,
            name=name,
            totp_secret=totp_secret,
            phone_number=phone_number,
            email=email,
            preferred_authentication_method=preferred_authentication_method,
            key_id=key_id,
            public_key=public_key,
            relying_party_identifier=relying_party_identifier,
            request_options=request_options,
        )
        return _response.data

    async def set(
        self,
        id: str,
        *,
        request: SetUserAuthenticationMethodsRequestContent,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[SetUserAuthenticationMethodResponseContent]:
        """
        Replace the specified user <a href="https://auth0.com/docs/secure/multi-factor-authentication/multi-factor-authentication-factors"> authentication methods</a> with supplied values.

            <b>Note</b>: Authentication methods supplied through this action do not iterate on existing methods. Instead, any methods passed will overwrite the user&#8217s existing settings.

        Parameters
        ----------
        id : str
            The ID of the user in question.

        request : SetUserAuthenticationMethodsRequestContent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[SetUserAuthenticationMethodResponseContent]
            All authentication methods successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0, SetUserAuthenticationMethods

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.users.authentication_methods.set(
                id="id",
                request=[
                    SetUserAuthenticationMethods(
                        type="phone",
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.set(id, request=request, request_options=request_options)
        return _response.data

    async def delete_all(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Remove all authentication methods (i.e., enrolled MFA factors) from the specified user account. This action cannot be undone.

        Parameters
        ----------
        id : str
            The ID of the user in question.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.users.authentication_methods.delete_all(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_all(id, request_options=request_options)
        return _response.data

    async def get(
        self, id: str, authentication_method_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetUserAuthenticationMethodResponseContent:
        """
        Parameters
        ----------
        id : str
            The ID of the user in question.

        authentication_method_id : str
            The ID of the authentication methods in question.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetUserAuthenticationMethodResponseContent
            Authentication method retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.users.authentication_methods.get(
                id="id",
                authentication_method_id="authentication_method_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, authentication_method_id, request_options=request_options)
        return _response.data

    async def delete(
        self, id: str, authentication_method_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Remove the authentication method with the given ID from the specified user. For more information, review <a href="https://auth0.com/docs/secure/multi-factor-authentication/manage-mfa-auth0-apis/manage-authentication-methods-with-management-api">Manage Authentication Methods with Management API</a>.

        Parameters
        ----------
        id : str
            The ID of the user in question.

        authentication_method_id : str
            The ID of the authentication method to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.users.authentication_methods.delete(
                id="id",
                authentication_method_id="authentication_method_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, authentication_method_id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        authentication_method_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        preferred_authentication_method: typing.Optional[PreferredAuthenticationMethodEnum] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateUserAuthenticationMethodResponseContent:
        """
        Modify the authentication method with the given ID from the specified user. For more information, review <a href="https://auth0.com/docs/secure/multi-factor-authentication/manage-mfa-auth0-apis/manage-authentication-methods-with-management-api">Manage Authentication Methods with Management API</a>.

        Parameters
        ----------
        id : str
            The ID of the user in question.

        authentication_method_id : str
            The ID of the authentication method to update.

        name : typing.Optional[str]
            A human-readable label to identify the authentication method.

        preferred_authentication_method : typing.Optional[PreferredAuthenticationMethodEnum]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateUserAuthenticationMethodResponseContent
            Authentication method updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.users.authentication_methods.update(
                id="id",
                authentication_method_id="authentication_method_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id,
            authentication_method_id,
            name=name,
            preferred_authentication_method=preferred_authentication_method,
            request_options=request_options,
        )
        return _response.data
