# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from .raw_client import AsyncRawAuthenticatorsClient, RawAuthenticatorsClient


class AuthenticatorsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAuthenticatorsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAuthenticatorsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAuthenticatorsClient
        """
        return self._raw_client

    def delete_all(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Remove all authenticators registered to a given user ID, such as OTP, email, phone, and push-notification. This action cannot be undone. For more information, review <a href="https://auth0.com/docs/secure/multi-factor-authentication/manage-mfa-auth0-apis/manage-authentication-methods-with-management-api">Manage Authentication Methods with Management API</a>.

        Parameters
        ----------
        id : str
            ID of the user to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.users.authenticators.delete_all(
            id="id",
        )
        """
        _response = self._raw_client.delete_all(id, request_options=request_options)
        return _response.data


class AsyncAuthenticatorsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAuthenticatorsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAuthenticatorsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAuthenticatorsClient
        """
        return self._raw_client

    async def delete_all(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Remove all authenticators registered to a given user ID, such as OTP, email, phone, and push-notification. This action cannot be undone. For more information, review <a href="https://auth0.com/docs/secure/multi-factor-authentication/manage-mfa-auth0-apis/manage-authentication-methods-with-management-api">Manage Authentication Methods with Management API</a>.

        Parameters
        ----------
        id : str
            ID of the user to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.users.authenticators.delete_all(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_all(id, request_options=request_options)
        return _response.data
