# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.app_metadata import AppMetadata
from ..types.create_user_response_content import CreateUserResponseContent
from ..types.get_user_response_content import GetUserResponseContent
from ..types.list_users_offset_paginated_response_content import ListUsersOffsetPaginatedResponseContent
from ..types.regenerate_users_recovery_code_response_content import RegenerateUsersRecoveryCodeResponseContent
from ..types.search_engine_versions_enum import SearchEngineVersionsEnum
from ..types.update_user_response_content import UpdateUserResponseContent
from ..types.user_metadata import UserMetadata
from ..types.user_response_schema import UserResponseSchema
from .raw_client import AsyncRawUsersClient, RawUsersClient

if typing.TYPE_CHECKING:
    from .authentication_methods.client import AsyncAuthenticationMethodsClient, AuthenticationMethodsClient
    from .authenticators.client import AsyncAuthenticatorsClient, AuthenticatorsClient
    from .connected_accounts.client import AsyncConnectedAccountsClient, ConnectedAccountsClient
    from .enrollments.client import AsyncEnrollmentsClient, EnrollmentsClient
    from .federated_connections_tokensets.client import (
        AsyncFederatedConnectionsTokensetsClient,
        FederatedConnectionsTokensetsClient,
    )
    from .identities.client import AsyncIdentitiesClient, IdentitiesClient
    from .logs.client import AsyncLogsClient, LogsClient
    from .multifactor.client import AsyncMultifactorClient, MultifactorClient
    from .organizations.client import AsyncOrganizationsClient, OrganizationsClient
    from .permissions.client import AsyncPermissionsClient, PermissionsClient
    from .refresh_token.client import AsyncRefreshTokenClient, RefreshTokenClient
    from .risk_assessments.client import AsyncRiskAssessmentsClient, RiskAssessmentsClient
    from .roles.client import AsyncRolesClient, RolesClient
    from .sessions.client import AsyncSessionsClient, SessionsClient
# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class UsersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawUsersClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._authentication_methods: typing.Optional[AuthenticationMethodsClient] = None
        self._authenticators: typing.Optional[AuthenticatorsClient] = None
        self._connected_accounts: typing.Optional[ConnectedAccountsClient] = None
        self._enrollments: typing.Optional[EnrollmentsClient] = None
        self._federated_connections_tokensets: typing.Optional[FederatedConnectionsTokensetsClient] = None
        self._identities: typing.Optional[IdentitiesClient] = None
        self._logs: typing.Optional[LogsClient] = None
        self._multifactor: typing.Optional[MultifactorClient] = None
        self._organizations: typing.Optional[OrganizationsClient] = None
        self._permissions: typing.Optional[PermissionsClient] = None
        self._risk_assessments: typing.Optional[RiskAssessmentsClient] = None
        self._roles: typing.Optional[RolesClient] = None
        self._refresh_token: typing.Optional[RefreshTokenClient] = None
        self._sessions: typing.Optional[SessionsClient] = None

    @property
    def with_raw_response(self) -> RawUsersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawUsersClient
        """
        return self._raw_client

    def list(
        self,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        sort: typing.Optional[str] = None,
        connection: typing.Optional[str] = None,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        q: typing.Optional[str] = None,
        search_engine: typing.Optional[SearchEngineVersionsEnum] = None,
        primary_order: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[UserResponseSchema, ListUsersOffsetPaginatedResponseContent]:
        """
        Retrieve details of users. It is possible to:

        - Specify a search criteria for users
        - Sort the users to be returned
        - Select the fields to be returned
        - Specify the number of users to retrieve per page and the page index
         <!-- only v3 is available -->
        The <code>q</code> query parameter can be used to get users that match the specified criteria <a href="https://auth0.com/docs/users/search/v3/query-syntax">using query string syntax.</a>

        <a href="https://auth0.com/docs/users/search/v3">Learn more about searching for users.</a>

        Read about <a href="https://auth0.com/docs/users/search/best-practices">best practices</a> when working with the API endpoints for retrieving users.

        Auth0 limits the number of users you can return. If you exceed this threshold, please redefine your search, use the <a href="https://auth0.com/docs/api/management/v2#!/Jobs/post_users_exports">export job</a>, or the <a href="https://auth0.com/docs/extensions/user-import-export">User Import / Export</a> extension.

        Parameters
        ----------
        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        sort : typing.Optional[str]
            Field to sort by. Use <code>field:order</code> where order is <code>1</code> for ascending and <code>-1</code> for descending. e.g. <code>created_at:1</code>

        connection : typing.Optional[str]
            Connection filter. Only applies when using <code>search_engine=v1</code>. To filter by connection with <code>search_engine=v2|v3</code>, use <code>q=identities.connection:"connection_name"</code>

        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (based on value provided for include_fields) in the result. Leave empty to retrieve all fields.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        q : typing.Optional[str]
            Query in <a target='_new' href ='http://www.lucenetutorial.com/lucene-query-syntax.html'>Lucene query string syntax</a>. Some query types cannot be used on metadata fields, for details see <a href='https://auth0.com/docs/users/search/v3/query-syntax#searchable-fields'>Searchable Fields</a>.

        search_engine : typing.Optional[SearchEngineVersionsEnum]
            The version of the search engine

        primary_order : typing.Optional[bool]
            If true (default), results are returned in a deterministic order. If false, results may be returned in a non-deterministic order, which can enhance performance for complex queries targeting a small number of users. Set to false only when consistent ordering and pagination is not required.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[UserResponseSchema, ListUsersOffsetPaginatedResponseContent]
            Users successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.users.list(
            page=1,
            per_page=1,
            include_totals=True,
            sort="sort",
            connection="connection",
            fields="fields",
            include_fields=True,
            q="q",
            search_engine="v1",
            primary_order=True,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            page=page,
            per_page=per_page,
            include_totals=include_totals,
            sort=sort,
            connection=connection,
            fields=fields,
            include_fields=include_fields,
            q=q,
            search_engine=search_engine,
            primary_order=primary_order,
            request_options=request_options,
        )

    def create(
        self,
        *,
        connection: str = "Initial-Connection",
        email: typing.Optional[str] = "john.doe@gmail.com",
        phone_number: typing.Optional[str] = "+199999999999999",
        user_metadata: typing.Optional[UserMetadata] = OMIT,
        blocked: typing.Optional[bool] = False,
        email_verified: typing.Optional[bool] = False,
        phone_verified: typing.Optional[bool] = False,
        app_metadata: typing.Optional[AppMetadata] = OMIT,
        given_name: typing.Optional[str] = "John",
        family_name: typing.Optional[str] = "Doe",
        name: typing.Optional[str] = "John Doe",
        nickname: typing.Optional[str] = "Johnny",
        picture: typing.Optional[
            str
        ] = "https://secure.gravatar.com/avatar/15626c5e0c749cb912f9d1ad48dba440?s=480&r=pg&d=https%3A%2F%2Fssl.gstatic.com%2Fs2%2Fprofiles%2Fimages%2Fsilhouette80.png",
        user_id: typing.Optional[str] = "abc",
        password: typing.Optional[str] = "secret",
        verify_email: typing.Optional[bool] = False,
        username: typing.Optional[str] = "johndoe",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateUserResponseContent:
        """
        Create a new user for a given <a href="https://auth0.com/docs/connections/database">database</a> or <a href="https://auth0.com/docs/connections/passwordless">passwordless</a> connection.

        Note: <code>connection</code> is required but other parameters such as <code>email</code> and <code>password</code> are dependent upon the type of connection.

        Parameters
        ----------
        connection : str
            Name of the connection this user should be created in.

        email : typing.Optional[str]
            The user's email.

        phone_number : typing.Optional[str]
            The user's phone number (following the E.164 recommendation).

        user_metadata : typing.Optional[UserMetadata]

        blocked : typing.Optional[bool]
            Whether this user was blocked by an administrator (true) or not (false).

        email_verified : typing.Optional[bool]
            Whether this email address is verified (true) or unverified (false). User will receive a verification email after creation if `email_verified` is false or not specified

        phone_verified : typing.Optional[bool]
            Whether this phone number has been verified (true) or not (false).

        app_metadata : typing.Optional[AppMetadata]

        given_name : typing.Optional[str]
            The user's given name(s).

        family_name : typing.Optional[str]
            The user's family name(s).

        name : typing.Optional[str]
            The user's full name.

        nickname : typing.Optional[str]
            The user's nickname.

        picture : typing.Optional[str]
            A URI pointing to the user's picture.

        user_id : typing.Optional[str]
            The external user's id provided by the identity provider.

        password : typing.Optional[str]
            Initial password for this user. Only valid for auth0 connection strategy.

        verify_email : typing.Optional[bool]
            Whether the user will receive a verification email after creation (true) or no email (false). Overrides behavior of `email_verified` parameter.

        username : typing.Optional[str]
            The user's username. Only valid if the connection requires a username.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateUserResponseContent
            User successfully created.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.users.create(
            connection="connection",
        )
        """
        _response = self._raw_client.create(
            connection=connection,
            email=email,
            phone_number=phone_number,
            user_metadata=user_metadata,
            blocked=blocked,
            email_verified=email_verified,
            phone_verified=phone_verified,
            app_metadata=app_metadata,
            given_name=given_name,
            family_name=family_name,
            name=name,
            nickname=nickname,
            picture=picture,
            user_id=user_id,
            password=password,
            verify_email=verify_email,
            username=username,
            request_options=request_options,
        )
        return _response.data

    def list_users_by_email(
        self,
        *,
        email: str,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[UserResponseSchema]:
        """
        Find users by email. If Auth0 is the identity provider (idP), the email address associated with a user is saved in lower case, regardless of how you initially provided it.

        For example, if you register a user as JohnSmith@example.com, Auth0 saves the user's email as johnsmith@example.com.

        Therefore, when using this endpoint, make sure that you are searching for users via email addresses using the correct case.

        Parameters
        ----------
        email : str
            Email address to search for (case-sensitive).

        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (based on value provided for include_fields) in the result. Leave empty to retrieve all fields.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false). Defaults to true.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[UserResponseSchema]
            Users successfully searched.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.users.list_users_by_email(
            fields="fields",
            include_fields=True,
            email="email",
        )
        """
        _response = self._raw_client.list_users_by_email(
            email=email, fields=fields, include_fields=include_fields, request_options=request_options
        )
        return _response.data

    def get(
        self,
        id: str,
        *,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetUserResponseContent:
        """
        Retrieve user details. A list of fields to include or exclude may also be specified. For more information, see <a href="https://auth0.com/docs/manage-users/user-search/retrieve-users-with-get-users-endpoint">Retrieve Users with the Get Users Endpoint</a>.

        Parameters
        ----------
        id : str
            ID of the user to retrieve.

        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (based on value provided for include_fields) in the result. Leave empty to retrieve all fields.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetUserResponseContent
            User successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.users.get(
            id="id",
            fields="fields",
            include_fields=True,
        )
        """
        _response = self._raw_client.get(
            id, fields=fields, include_fields=include_fields, request_options=request_options
        )
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a user by user ID. This action cannot be undone. For Auth0 Dashboard instructions, see <a href="https://auth0.com/docs/manage-users/user-accounts/delete-users">Delete Users</a>.

        Parameters
        ----------
        id : str
            ID of the user to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.users.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        blocked: typing.Optional[bool] = False,
        email_verified: typing.Optional[bool] = False,
        email: typing.Optional[str] = "john.doe@gmail.com",
        phone_number: typing.Optional[str] = "+199999999999999",
        phone_verified: typing.Optional[bool] = False,
        user_metadata: typing.Optional[UserMetadata] = OMIT,
        app_metadata: typing.Optional[AppMetadata] = OMIT,
        given_name: typing.Optional[str] = "John",
        family_name: typing.Optional[str] = "Doe",
        name: typing.Optional[str] = "John Doe",
        nickname: typing.Optional[str] = "Johnny",
        picture: typing.Optional[
            str
        ] = "https://secure.gravatar.com/avatar/15626c5e0c749cb912f9d1ad48dba440?s=480&r=pg&d=https%3A%2F%2Fssl.gstatic.com%2Fs2%2Fprofiles%2Fimages%2Fsilhouette80.png",
        verify_email: typing.Optional[bool] = False,
        verify_phone_number: typing.Optional[bool] = False,
        password: typing.Optional[str] = "secret",
        connection: typing.Optional[str] = "Initial-Connection",
        client_id: typing.Optional[str] = "DaM8bokEXBWrTUFCiJjWn50jei6ardyX",
        username: typing.Optional[str] = "johndoe",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateUserResponseContent:
        """
        Update a user.

        These are the attributes that can be updated at the root level:

        <ul>
            <li>app_metadata</li>
            <li>blocked</li>
            <li>email</li>
            <li>email_verified</li>
            <li>family_name</li>
            <li>given_name</li>
            <li>name</li>
            <li>nickname</li>
            <li>password</li>
            <li>phone_number</li>
            <li>phone_verified</li>
            <li>picture</li>
            <li>username</li>
            <li>user_metadata</li>
            <li>verify_email</li>
        </ul>

        Some considerations:
        <ul>
            <li>The properties of the new object will replace the old ones.</li>
            <li>The metadata fields are an exception to this rule (<code>user_metadata</code> and <code>app_metadata</code>). These properties are merged instead of being replaced but be careful, the merge only occurs on the first level.</li>
            <li>If you are updating <code>email</code>, <code>email_verified</code>, <code>phone_number</code>, <code>phone_verified</code>, <code>username</code> or <code>password</code> of a secondary identity, you need to specify the <code>connection</code> property too.</li>
            <li>If you are updating <code>email</code> or <code>phone_number</code> you can specify, optionally, the <code>client_id</code> property.</li>
            <li>Updating <code>email_verified</code> is not supported for enterprise and passwordless sms connections.</li>
            <li>Updating the <code>blocked</code> to <code>false</code> does not affect the user's blocked state from an excessive amount of incorrectly provided credentials. Use the "Unblock a user" endpoint from the "User Blocks" API to change the user's state.</li>
            <li>Supported attributes can be unset by supplying <code>null</code> as the value.</li>
        </ul>

        <h5>Updating a field (non-metadata property)</h5>
        To mark the email address of a user as verified, the body to send should be:
        <pre><code>{ "email_verified": true }</code></pre>

        <h5>Updating a user metadata root property</h5>Let's assume that our test user has the following <code>user_metadata</code>:
        <pre><code>{ "user_metadata" : { "profileCode": 1479 } }</code></pre>

        To add the field <code>addresses</code> the body to send should be:
        <pre><code>{ "user_metadata" : { "addresses": {"work_address": "100 Industrial Way"} }}</code></pre>

        The modified object ends up with the following <code>user_metadata</code> property:<pre><code>{
          "user_metadata": {
            "profileCode": 1479,
            "addresses": { "work_address": "100 Industrial Way" }
          }
        }</code></pre>

        <h5>Updating an inner user metadata property</h5>If there's existing user metadata to which we want to add  <code>"home_address": "742 Evergreen Terrace"</code> (using the <code>addresses</code> property) we should send the whole <code>addresses</code> object. Since this is a first-level object, the object will be merged in, but its own properties will not be. The body to send should be:
        <pre><code>{
          "user_metadata": {
            "addresses": {
              "work_address": "100 Industrial Way",
              "home_address": "742 Evergreen Terrace"
            }
          }
        }</code></pre>

        The modified object ends up with the following <code>user_metadata</code> property:
        <pre><code>{
          "user_metadata": {
            "profileCode": 1479,
            "addresses": {
              "work_address": "100 Industrial Way",
              "home_address": "742 Evergreen Terrace"
            }
          }
        }</code></pre>

        Parameters
        ----------
        id : str
            ID of the user to update.

        blocked : typing.Optional[bool]
            Whether this user was blocked by an administrator (true) or not (false).

        email_verified : typing.Optional[bool]
            Whether this email address is verified (true) or unverified (false). If set to false the user will not receive a verification email unless `verify_email` is set to true.

        email : typing.Optional[str]
            Email address of this user.

        phone_number : typing.Optional[str]
            The user's phone number (following the E.164 recommendation).

        phone_verified : typing.Optional[bool]
            Whether this phone number has been verified (true) or not (false).

        user_metadata : typing.Optional[UserMetadata]

        app_metadata : typing.Optional[AppMetadata]

        given_name : typing.Optional[str]
            Given name/first name/forename of this user.

        family_name : typing.Optional[str]
            Family name/last name/surname of this user.

        name : typing.Optional[str]
            Name of this user.

        nickname : typing.Optional[str]
            Preferred nickname or alias of this user.

        picture : typing.Optional[str]
            URL to picture, photo, or avatar of this user.

        verify_email : typing.Optional[bool]
            Whether this user will receive a verification email after creation (true) or no email (false). Overrides behavior of `email_verified` parameter.

        verify_phone_number : typing.Optional[bool]
            Whether this user will receive a text after changing the phone number (true) or no text (false). Only valid when changing phone number for SMS connections.

        password : typing.Optional[str]
            New password for this user. Only valid for database connections.

        connection : typing.Optional[str]
            Name of the connection to target for this user update.

        client_id : typing.Optional[str]
            Auth0 client ID. Only valid when updating email address.

        username : typing.Optional[str]
            The user's username. Only valid if the connection requires a username.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateUserResponseContent
            User successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.users.update(
            id="id",
        )
        """
        _response = self._raw_client.update(
            id,
            blocked=blocked,
            email_verified=email_verified,
            email=email,
            phone_number=phone_number,
            phone_verified=phone_verified,
            user_metadata=user_metadata,
            app_metadata=app_metadata,
            given_name=given_name,
            family_name=family_name,
            name=name,
            nickname=nickname,
            picture=picture,
            verify_email=verify_email,
            verify_phone_number=verify_phone_number,
            password=password,
            connection=connection,
            client_id=client_id,
            username=username,
            request_options=request_options,
        )
        return _response.data

    def regenerate_recovery_code(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> RegenerateUsersRecoveryCodeResponseContent:
        """
        Remove an existing multi-factor authentication (MFA) <a href="https://auth0.com/docs/secure/multi-factor-authentication/reset-user-mfa">recovery code</a> and generate a new one. If a user cannot access the original device or account used for MFA enrollment, they can use a recovery code to authenticate.

        Parameters
        ----------
        id : str
            ID of the user to regenerate a multi-factor authentication recovery code for.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RegenerateUsersRecoveryCodeResponseContent
            New recovery code successfully generated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.users.regenerate_recovery_code(
            id="id",
        )
        """
        _response = self._raw_client.regenerate_recovery_code(id, request_options=request_options)
        return _response.data

    def revoke_access(
        self,
        id: str,
        *,
        session_id: typing.Optional[str] = OMIT,
        preserve_refresh_tokens: typing.Optional[bool] = False,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Revokes selected resources related to a user (sessions, refresh tokens, ...).

        Parameters
        ----------
        id : str
            ID of the user.

        session_id : typing.Optional[str]
            ID of the session to revoke.

        preserve_refresh_tokens : typing.Optional[bool]
            Whether to preserve the refresh tokens associated with the session.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.users.revoke_access(
            id="id",
        )
        """
        _response = self._raw_client.revoke_access(
            id, session_id=session_id, preserve_refresh_tokens=preserve_refresh_tokens, request_options=request_options
        )
        return _response.data

    @property
    def authentication_methods(self):
        if self._authentication_methods is None:
            from .authentication_methods.client import AuthenticationMethodsClient  # noqa: E402

            self._authentication_methods = AuthenticationMethodsClient(client_wrapper=self._client_wrapper)
        return self._authentication_methods

    @property
    def authenticators(self):
        if self._authenticators is None:
            from .authenticators.client import AuthenticatorsClient  # noqa: E402

            self._authenticators = AuthenticatorsClient(client_wrapper=self._client_wrapper)
        return self._authenticators

    @property
    def connected_accounts(self):
        if self._connected_accounts is None:
            from .connected_accounts.client import ConnectedAccountsClient  # noqa: E402

            self._connected_accounts = ConnectedAccountsClient(client_wrapper=self._client_wrapper)
        return self._connected_accounts

    @property
    def enrollments(self):
        if self._enrollments is None:
            from .enrollments.client import EnrollmentsClient  # noqa: E402

            self._enrollments = EnrollmentsClient(client_wrapper=self._client_wrapper)
        return self._enrollments

    @property
    def federated_connections_tokensets(self):
        if self._federated_connections_tokensets is None:
            from .federated_connections_tokensets.client import FederatedConnectionsTokensetsClient  # noqa: E402

            self._federated_connections_tokensets = FederatedConnectionsTokensetsClient(
                client_wrapper=self._client_wrapper
            )
        return self._federated_connections_tokensets

    @property
    def identities(self):
        if self._identities is None:
            from .identities.client import IdentitiesClient  # noqa: E402

            self._identities = IdentitiesClient(client_wrapper=self._client_wrapper)
        return self._identities

    @property
    def logs(self):
        if self._logs is None:
            from .logs.client import LogsClient  # noqa: E402

            self._logs = LogsClient(client_wrapper=self._client_wrapper)
        return self._logs

    @property
    def multifactor(self):
        if self._multifactor is None:
            from .multifactor.client import MultifactorClient  # noqa: E402

            self._multifactor = MultifactorClient(client_wrapper=self._client_wrapper)
        return self._multifactor

    @property
    def organizations(self):
        if self._organizations is None:
            from .organizations.client import OrganizationsClient  # noqa: E402

            self._organizations = OrganizationsClient(client_wrapper=self._client_wrapper)
        return self._organizations

    @property
    def permissions(self):
        if self._permissions is None:
            from .permissions.client import PermissionsClient  # noqa: E402

            self._permissions = PermissionsClient(client_wrapper=self._client_wrapper)
        return self._permissions

    @property
    def risk_assessments(self):
        if self._risk_assessments is None:
            from .risk_assessments.client import RiskAssessmentsClient  # noqa: E402

            self._risk_assessments = RiskAssessmentsClient(client_wrapper=self._client_wrapper)
        return self._risk_assessments

    @property
    def roles(self):
        if self._roles is None:
            from .roles.client import RolesClient  # noqa: E402

            self._roles = RolesClient(client_wrapper=self._client_wrapper)
        return self._roles

    @property
    def refresh_token(self):
        if self._refresh_token is None:
            from .refresh_token.client import RefreshTokenClient  # noqa: E402

            self._refresh_token = RefreshTokenClient(client_wrapper=self._client_wrapper)
        return self._refresh_token

    @property
    def sessions(self):
        if self._sessions is None:
            from .sessions.client import SessionsClient  # noqa: E402

            self._sessions = SessionsClient(client_wrapper=self._client_wrapper)
        return self._sessions


class AsyncUsersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawUsersClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._authentication_methods: typing.Optional[AsyncAuthenticationMethodsClient] = None
        self._authenticators: typing.Optional[AsyncAuthenticatorsClient] = None
        self._connected_accounts: typing.Optional[AsyncConnectedAccountsClient] = None
        self._enrollments: typing.Optional[AsyncEnrollmentsClient] = None
        self._federated_connections_tokensets: typing.Optional[AsyncFederatedConnectionsTokensetsClient] = None
        self._identities: typing.Optional[AsyncIdentitiesClient] = None
        self._logs: typing.Optional[AsyncLogsClient] = None
        self._multifactor: typing.Optional[AsyncMultifactorClient] = None
        self._organizations: typing.Optional[AsyncOrganizationsClient] = None
        self._permissions: typing.Optional[AsyncPermissionsClient] = None
        self._risk_assessments: typing.Optional[AsyncRiskAssessmentsClient] = None
        self._roles: typing.Optional[AsyncRolesClient] = None
        self._refresh_token: typing.Optional[AsyncRefreshTokenClient] = None
        self._sessions: typing.Optional[AsyncSessionsClient] = None

    @property
    def with_raw_response(self) -> AsyncRawUsersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawUsersClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        sort: typing.Optional[str] = None,
        connection: typing.Optional[str] = None,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        q: typing.Optional[str] = None,
        search_engine: typing.Optional[SearchEngineVersionsEnum] = None,
        primary_order: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[UserResponseSchema, ListUsersOffsetPaginatedResponseContent]:
        """
        Retrieve details of users. It is possible to:

        - Specify a search criteria for users
        - Sort the users to be returned
        - Select the fields to be returned
        - Specify the number of users to retrieve per page and the page index
         <!-- only v3 is available -->
        The <code>q</code> query parameter can be used to get users that match the specified criteria <a href="https://auth0.com/docs/users/search/v3/query-syntax">using query string syntax.</a>

        <a href="https://auth0.com/docs/users/search/v3">Learn more about searching for users.</a>

        Read about <a href="https://auth0.com/docs/users/search/best-practices">best practices</a> when working with the API endpoints for retrieving users.

        Auth0 limits the number of users you can return. If you exceed this threshold, please redefine your search, use the <a href="https://auth0.com/docs/api/management/v2#!/Jobs/post_users_exports">export job</a>, or the <a href="https://auth0.com/docs/extensions/user-import-export">User Import / Export</a> extension.

        Parameters
        ----------
        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        sort : typing.Optional[str]
            Field to sort by. Use <code>field:order</code> where order is <code>1</code> for ascending and <code>-1</code> for descending. e.g. <code>created_at:1</code>

        connection : typing.Optional[str]
            Connection filter. Only applies when using <code>search_engine=v1</code>. To filter by connection with <code>search_engine=v2|v3</code>, use <code>q=identities.connection:"connection_name"</code>

        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (based on value provided for include_fields) in the result. Leave empty to retrieve all fields.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        q : typing.Optional[str]
            Query in <a target='_new' href ='http://www.lucenetutorial.com/lucene-query-syntax.html'>Lucene query string syntax</a>. Some query types cannot be used on metadata fields, for details see <a href='https://auth0.com/docs/users/search/v3/query-syntax#searchable-fields'>Searchable Fields</a>.

        search_engine : typing.Optional[SearchEngineVersionsEnum]
            The version of the search engine

        primary_order : typing.Optional[bool]
            If true (default), results are returned in a deterministic order. If false, results may be returned in a non-deterministic order, which can enhance performance for complex queries targeting a small number of users. Set to false only when consistent ordering and pagination is not required.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[UserResponseSchema, ListUsersOffsetPaginatedResponseContent]
            Users successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.users.list(
                page=1,
                per_page=1,
                include_totals=True,
                sort="sort",
                connection="connection",
                fields="fields",
                include_fields=True,
                q="q",
                search_engine="v1",
                primary_order=True,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            page=page,
            per_page=per_page,
            include_totals=include_totals,
            sort=sort,
            connection=connection,
            fields=fields,
            include_fields=include_fields,
            q=q,
            search_engine=search_engine,
            primary_order=primary_order,
            request_options=request_options,
        )

    async def create(
        self,
        *,
        connection: str = "Initial-Connection",
        email: typing.Optional[str] = "john.doe@gmail.com",
        phone_number: typing.Optional[str] = "+199999999999999",
        user_metadata: typing.Optional[UserMetadata] = OMIT,
        blocked: typing.Optional[bool] = False,
        email_verified: typing.Optional[bool] = False,
        phone_verified: typing.Optional[bool] = False,
        app_metadata: typing.Optional[AppMetadata] = OMIT,
        given_name: typing.Optional[str] = "John",
        family_name: typing.Optional[str] = "Doe",
        name: typing.Optional[str] = "John Doe",
        nickname: typing.Optional[str] = "Johnny",
        picture: typing.Optional[
            str
        ] = "https://secure.gravatar.com/avatar/15626c5e0c749cb912f9d1ad48dba440?s=480&r=pg&d=https%3A%2F%2Fssl.gstatic.com%2Fs2%2Fprofiles%2Fimages%2Fsilhouette80.png",
        user_id: typing.Optional[str] = "abc",
        password: typing.Optional[str] = "secret",
        verify_email: typing.Optional[bool] = False,
        username: typing.Optional[str] = "johndoe",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateUserResponseContent:
        """
        Create a new user for a given <a href="https://auth0.com/docs/connections/database">database</a> or <a href="https://auth0.com/docs/connections/passwordless">passwordless</a> connection.

        Note: <code>connection</code> is required but other parameters such as <code>email</code> and <code>password</code> are dependent upon the type of connection.

        Parameters
        ----------
        connection : str
            Name of the connection this user should be created in.

        email : typing.Optional[str]
            The user's email.

        phone_number : typing.Optional[str]
            The user's phone number (following the E.164 recommendation).

        user_metadata : typing.Optional[UserMetadata]

        blocked : typing.Optional[bool]
            Whether this user was blocked by an administrator (true) or not (false).

        email_verified : typing.Optional[bool]
            Whether this email address is verified (true) or unverified (false). User will receive a verification email after creation if `email_verified` is false or not specified

        phone_verified : typing.Optional[bool]
            Whether this phone number has been verified (true) or not (false).

        app_metadata : typing.Optional[AppMetadata]

        given_name : typing.Optional[str]
            The user's given name(s).

        family_name : typing.Optional[str]
            The user's family name(s).

        name : typing.Optional[str]
            The user's full name.

        nickname : typing.Optional[str]
            The user's nickname.

        picture : typing.Optional[str]
            A URI pointing to the user's picture.

        user_id : typing.Optional[str]
            The external user's id provided by the identity provider.

        password : typing.Optional[str]
            Initial password for this user. Only valid for auth0 connection strategy.

        verify_email : typing.Optional[bool]
            Whether the user will receive a verification email after creation (true) or no email (false). Overrides behavior of `email_verified` parameter.

        username : typing.Optional[str]
            The user's username. Only valid if the connection requires a username.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateUserResponseContent
            User successfully created.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.users.create(
                connection="connection",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            connection=connection,
            email=email,
            phone_number=phone_number,
            user_metadata=user_metadata,
            blocked=blocked,
            email_verified=email_verified,
            phone_verified=phone_verified,
            app_metadata=app_metadata,
            given_name=given_name,
            family_name=family_name,
            name=name,
            nickname=nickname,
            picture=picture,
            user_id=user_id,
            password=password,
            verify_email=verify_email,
            username=username,
            request_options=request_options,
        )
        return _response.data

    async def list_users_by_email(
        self,
        *,
        email: str,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[UserResponseSchema]:
        """
        Find users by email. If Auth0 is the identity provider (idP), the email address associated with a user is saved in lower case, regardless of how you initially provided it.

        For example, if you register a user as JohnSmith@example.com, Auth0 saves the user's email as johnsmith@example.com.

        Therefore, when using this endpoint, make sure that you are searching for users via email addresses using the correct case.

        Parameters
        ----------
        email : str
            Email address to search for (case-sensitive).

        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (based on value provided for include_fields) in the result. Leave empty to retrieve all fields.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false). Defaults to true.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[UserResponseSchema]
            Users successfully searched.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.users.list_users_by_email(
                fields="fields",
                include_fields=True,
                email="email",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_users_by_email(
            email=email, fields=fields, include_fields=include_fields, request_options=request_options
        )
        return _response.data

    async def get(
        self,
        id: str,
        *,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetUserResponseContent:
        """
        Retrieve user details. A list of fields to include or exclude may also be specified. For more information, see <a href="https://auth0.com/docs/manage-users/user-search/retrieve-users-with-get-users-endpoint">Retrieve Users with the Get Users Endpoint</a>.

        Parameters
        ----------
        id : str
            ID of the user to retrieve.

        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (based on value provided for include_fields) in the result. Leave empty to retrieve all fields.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetUserResponseContent
            User successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.users.get(
                id="id",
                fields="fields",
                include_fields=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            id, fields=fields, include_fields=include_fields, request_options=request_options
        )
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a user by user ID. This action cannot be undone. For Auth0 Dashboard instructions, see <a href="https://auth0.com/docs/manage-users/user-accounts/delete-users">Delete Users</a>.

        Parameters
        ----------
        id : str
            ID of the user to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.users.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        blocked: typing.Optional[bool] = False,
        email_verified: typing.Optional[bool] = False,
        email: typing.Optional[str] = "john.doe@gmail.com",
        phone_number: typing.Optional[str] = "+199999999999999",
        phone_verified: typing.Optional[bool] = False,
        user_metadata: typing.Optional[UserMetadata] = OMIT,
        app_metadata: typing.Optional[AppMetadata] = OMIT,
        given_name: typing.Optional[str] = "John",
        family_name: typing.Optional[str] = "Doe",
        name: typing.Optional[str] = "John Doe",
        nickname: typing.Optional[str] = "Johnny",
        picture: typing.Optional[
            str
        ] = "https://secure.gravatar.com/avatar/15626c5e0c749cb912f9d1ad48dba440?s=480&r=pg&d=https%3A%2F%2Fssl.gstatic.com%2Fs2%2Fprofiles%2Fimages%2Fsilhouette80.png",
        verify_email: typing.Optional[bool] = False,
        verify_phone_number: typing.Optional[bool] = False,
        password: typing.Optional[str] = "secret",
        connection: typing.Optional[str] = "Initial-Connection",
        client_id: typing.Optional[str] = "DaM8bokEXBWrTUFCiJjWn50jei6ardyX",
        username: typing.Optional[str] = "johndoe",
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateUserResponseContent:
        """
        Update a user.

        These are the attributes that can be updated at the root level:

        <ul>
            <li>app_metadata</li>
            <li>blocked</li>
            <li>email</li>
            <li>email_verified</li>
            <li>family_name</li>
            <li>given_name</li>
            <li>name</li>
            <li>nickname</li>
            <li>password</li>
            <li>phone_number</li>
            <li>phone_verified</li>
            <li>picture</li>
            <li>username</li>
            <li>user_metadata</li>
            <li>verify_email</li>
        </ul>

        Some considerations:
        <ul>
            <li>The properties of the new object will replace the old ones.</li>
            <li>The metadata fields are an exception to this rule (<code>user_metadata</code> and <code>app_metadata</code>). These properties are merged instead of being replaced but be careful, the merge only occurs on the first level.</li>
            <li>If you are updating <code>email</code>, <code>email_verified</code>, <code>phone_number</code>, <code>phone_verified</code>, <code>username</code> or <code>password</code> of a secondary identity, you need to specify the <code>connection</code> property too.</li>
            <li>If you are updating <code>email</code> or <code>phone_number</code> you can specify, optionally, the <code>client_id</code> property.</li>
            <li>Updating <code>email_verified</code> is not supported for enterprise and passwordless sms connections.</li>
            <li>Updating the <code>blocked</code> to <code>false</code> does not affect the user's blocked state from an excessive amount of incorrectly provided credentials. Use the "Unblock a user" endpoint from the "User Blocks" API to change the user's state.</li>
            <li>Supported attributes can be unset by supplying <code>null</code> as the value.</li>
        </ul>

        <h5>Updating a field (non-metadata property)</h5>
        To mark the email address of a user as verified, the body to send should be:
        <pre><code>{ "email_verified": true }</code></pre>

        <h5>Updating a user metadata root property</h5>Let's assume that our test user has the following <code>user_metadata</code>:
        <pre><code>{ "user_metadata" : { "profileCode": 1479 } }</code></pre>

        To add the field <code>addresses</code> the body to send should be:
        <pre><code>{ "user_metadata" : { "addresses": {"work_address": "100 Industrial Way"} }}</code></pre>

        The modified object ends up with the following <code>user_metadata</code> property:<pre><code>{
          "user_metadata": {
            "profileCode": 1479,
            "addresses": { "work_address": "100 Industrial Way" }
          }
        }</code></pre>

        <h5>Updating an inner user metadata property</h5>If there's existing user metadata to which we want to add  <code>"home_address": "742 Evergreen Terrace"</code> (using the <code>addresses</code> property) we should send the whole <code>addresses</code> object. Since this is a first-level object, the object will be merged in, but its own properties will not be. The body to send should be:
        <pre><code>{
          "user_metadata": {
            "addresses": {
              "work_address": "100 Industrial Way",
              "home_address": "742 Evergreen Terrace"
            }
          }
        }</code></pre>

        The modified object ends up with the following <code>user_metadata</code> property:
        <pre><code>{
          "user_metadata": {
            "profileCode": 1479,
            "addresses": {
              "work_address": "100 Industrial Way",
              "home_address": "742 Evergreen Terrace"
            }
          }
        }</code></pre>

        Parameters
        ----------
        id : str
            ID of the user to update.

        blocked : typing.Optional[bool]
            Whether this user was blocked by an administrator (true) or not (false).

        email_verified : typing.Optional[bool]
            Whether this email address is verified (true) or unverified (false). If set to false the user will not receive a verification email unless `verify_email` is set to true.

        email : typing.Optional[str]
            Email address of this user.

        phone_number : typing.Optional[str]
            The user's phone number (following the E.164 recommendation).

        phone_verified : typing.Optional[bool]
            Whether this phone number has been verified (true) or not (false).

        user_metadata : typing.Optional[UserMetadata]

        app_metadata : typing.Optional[AppMetadata]

        given_name : typing.Optional[str]
            Given name/first name/forename of this user.

        family_name : typing.Optional[str]
            Family name/last name/surname of this user.

        name : typing.Optional[str]
            Name of this user.

        nickname : typing.Optional[str]
            Preferred nickname or alias of this user.

        picture : typing.Optional[str]
            URL to picture, photo, or avatar of this user.

        verify_email : typing.Optional[bool]
            Whether this user will receive a verification email after creation (true) or no email (false). Overrides behavior of `email_verified` parameter.

        verify_phone_number : typing.Optional[bool]
            Whether this user will receive a text after changing the phone number (true) or no text (false). Only valid when changing phone number for SMS connections.

        password : typing.Optional[str]
            New password for this user. Only valid for database connections.

        connection : typing.Optional[str]
            Name of the connection to target for this user update.

        client_id : typing.Optional[str]
            Auth0 client ID. Only valid when updating email address.

        username : typing.Optional[str]
            The user's username. Only valid if the connection requires a username.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateUserResponseContent
            User successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.users.update(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id,
            blocked=blocked,
            email_verified=email_verified,
            email=email,
            phone_number=phone_number,
            phone_verified=phone_verified,
            user_metadata=user_metadata,
            app_metadata=app_metadata,
            given_name=given_name,
            family_name=family_name,
            name=name,
            nickname=nickname,
            picture=picture,
            verify_email=verify_email,
            verify_phone_number=verify_phone_number,
            password=password,
            connection=connection,
            client_id=client_id,
            username=username,
            request_options=request_options,
        )
        return _response.data

    async def regenerate_recovery_code(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> RegenerateUsersRecoveryCodeResponseContent:
        """
        Remove an existing multi-factor authentication (MFA) <a href="https://auth0.com/docs/secure/multi-factor-authentication/reset-user-mfa">recovery code</a> and generate a new one. If a user cannot access the original device or account used for MFA enrollment, they can use a recovery code to authenticate.

        Parameters
        ----------
        id : str
            ID of the user to regenerate a multi-factor authentication recovery code for.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RegenerateUsersRecoveryCodeResponseContent
            New recovery code successfully generated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.users.regenerate_recovery_code(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.regenerate_recovery_code(id, request_options=request_options)
        return _response.data

    async def revoke_access(
        self,
        id: str,
        *,
        session_id: typing.Optional[str] = OMIT,
        preserve_refresh_tokens: typing.Optional[bool] = False,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Revokes selected resources related to a user (sessions, refresh tokens, ...).

        Parameters
        ----------
        id : str
            ID of the user.

        session_id : typing.Optional[str]
            ID of the session to revoke.

        preserve_refresh_tokens : typing.Optional[bool]
            Whether to preserve the refresh tokens associated with the session.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.users.revoke_access(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.revoke_access(
            id, session_id=session_id, preserve_refresh_tokens=preserve_refresh_tokens, request_options=request_options
        )
        return _response.data

    @property
    def authentication_methods(self):
        if self._authentication_methods is None:
            from .authentication_methods.client import AsyncAuthenticationMethodsClient  # noqa: E402

            self._authentication_methods = AsyncAuthenticationMethodsClient(client_wrapper=self._client_wrapper)
        return self._authentication_methods

    @property
    def authenticators(self):
        if self._authenticators is None:
            from .authenticators.client import AsyncAuthenticatorsClient  # noqa: E402

            self._authenticators = AsyncAuthenticatorsClient(client_wrapper=self._client_wrapper)
        return self._authenticators

    @property
    def connected_accounts(self):
        if self._connected_accounts is None:
            from .connected_accounts.client import AsyncConnectedAccountsClient  # noqa: E402

            self._connected_accounts = AsyncConnectedAccountsClient(client_wrapper=self._client_wrapper)
        return self._connected_accounts

    @property
    def enrollments(self):
        if self._enrollments is None:
            from .enrollments.client import AsyncEnrollmentsClient  # noqa: E402

            self._enrollments = AsyncEnrollmentsClient(client_wrapper=self._client_wrapper)
        return self._enrollments

    @property
    def federated_connections_tokensets(self):
        if self._federated_connections_tokensets is None:
            from .federated_connections_tokensets.client import AsyncFederatedConnectionsTokensetsClient  # noqa: E402

            self._federated_connections_tokensets = AsyncFederatedConnectionsTokensetsClient(
                client_wrapper=self._client_wrapper
            )
        return self._federated_connections_tokensets

    @property
    def identities(self):
        if self._identities is None:
            from .identities.client import AsyncIdentitiesClient  # noqa: E402

            self._identities = AsyncIdentitiesClient(client_wrapper=self._client_wrapper)
        return self._identities

    @property
    def logs(self):
        if self._logs is None:
            from .logs.client import AsyncLogsClient  # noqa: E402

            self._logs = AsyncLogsClient(client_wrapper=self._client_wrapper)
        return self._logs

    @property
    def multifactor(self):
        if self._multifactor is None:
            from .multifactor.client import AsyncMultifactorClient  # noqa: E402

            self._multifactor = AsyncMultifactorClient(client_wrapper=self._client_wrapper)
        return self._multifactor

    @property
    def organizations(self):
        if self._organizations is None:
            from .organizations.client import AsyncOrganizationsClient  # noqa: E402

            self._organizations = AsyncOrganizationsClient(client_wrapper=self._client_wrapper)
        return self._organizations

    @property
    def permissions(self):
        if self._permissions is None:
            from .permissions.client import AsyncPermissionsClient  # noqa: E402

            self._permissions = AsyncPermissionsClient(client_wrapper=self._client_wrapper)
        return self._permissions

    @property
    def risk_assessments(self):
        if self._risk_assessments is None:
            from .risk_assessments.client import AsyncRiskAssessmentsClient  # noqa: E402

            self._risk_assessments = AsyncRiskAssessmentsClient(client_wrapper=self._client_wrapper)
        return self._risk_assessments

    @property
    def roles(self):
        if self._roles is None:
            from .roles.client import AsyncRolesClient  # noqa: E402

            self._roles = AsyncRolesClient(client_wrapper=self._client_wrapper)
        return self._roles

    @property
    def refresh_token(self):
        if self._refresh_token is None:
            from .refresh_token.client import AsyncRefreshTokenClient  # noqa: E402

            self._refresh_token = AsyncRefreshTokenClient(client_wrapper=self._client_wrapper)
        return self._refresh_token

    @property
    def sessions(self):
        if self._sessions is None:
            from .sessions.client import AsyncSessionsClient  # noqa: E402

            self._sessions = AsyncSessionsClient(client_wrapper=self._client_wrapper)
        return self._sessions
