# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pagination import AsyncPager, SyncPager
from ...core.request_options import RequestOptions
from ...types.connected_account import ConnectedAccount
from ...types.list_user_connected_accounts_response_content import ListUserConnectedAccountsResponseContent
from .raw_client import AsyncRawConnectedAccountsClient, RawConnectedAccountsClient


class ConnectedAccountsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawConnectedAccountsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawConnectedAccountsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawConnectedAccountsClient
        """
        return self._raw_client

    def list(
        self,
        id: str,
        *,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[ConnectedAccount, ListUserConnectedAccountsResponseContent]:
        """
        Retrieve all connected accounts associated with the user.

        Parameters
        ----------
        id : str
            ID of the user to list connected accounts for.

        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results to return.  Defaults to 10 with a maximum of 20

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[ConnectedAccount, ListUserConnectedAccountsResponseContent]
            Connected accounts successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.users.connected_accounts.list(
            id="id",
            from_="from",
            take=1,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(id, from_=from_, take=take, request_options=request_options)


class AsyncConnectedAccountsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawConnectedAccountsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawConnectedAccountsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawConnectedAccountsClient
        """
        return self._raw_client

    async def list(
        self,
        id: str,
        *,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[ConnectedAccount, ListUserConnectedAccountsResponseContent]:
        """
        Retrieve all connected accounts associated with the user.

        Parameters
        ----------
        id : str
            ID of the user to list connected accounts for.

        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results to return.  Defaults to 10 with a maximum of 20

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[ConnectedAccount, ListUserConnectedAccountsResponseContent]
            Connected accounts successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.users.connected_accounts.list(
                id="id",
                from_="from",
                take=1,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(id, from_=from_, take=take, request_options=request_options)
