# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pagination import AsyncPager, SyncPager
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...errors.bad_request_error import BadRequestError
from ...errors.forbidden_error import ForbiddenError
from ...errors.too_many_requests_error import TooManyRequestsError
from ...errors.unauthorized_error import UnauthorizedError
from ...types.connected_account import ConnectedAccount
from ...types.list_user_connected_accounts_response_content import ListUserConnectedAccountsResponseContent


class RawConnectedAccountsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        id: str,
        *,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[ConnectedAccount, ListUserConnectedAccountsResponseContent]:
        """
        Retrieve all connected accounts associated with the user.

        Parameters
        ----------
        id : str
            ID of the user to list connected accounts for.

        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results to return.  Defaults to 10 with a maximum of 20

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[ConnectedAccount, ListUserConnectedAccountsResponseContent]
            Connected accounts successfully retrieved.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"users/{jsonable_encoder(id)}/connected-accounts",
            method="GET",
            params={
                "from": from_,
                "take": take,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    ListUserConnectedAccountsResponseContent,
                    parse_obj_as(
                        type_=ListUserConnectedAccountsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.connected_accounts
                _parsed_next = _parsed_response.next
                _has_next = _parsed_next is not None and _parsed_next != ""
                _get_next = lambda: self.list(
                    id,
                    from_=_parsed_next,
                    take=take,
                    request_options=request_options,
                )
                return SyncPager(has_next=_has_next, items=_items, get_next=_get_next, response=_parsed_response)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawConnectedAccountsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        id: str,
        *,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[ConnectedAccount, ListUserConnectedAccountsResponseContent]:
        """
        Retrieve all connected accounts associated with the user.

        Parameters
        ----------
        id : str
            ID of the user to list connected accounts for.

        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results to return.  Defaults to 10 with a maximum of 20

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[ConnectedAccount, ListUserConnectedAccountsResponseContent]
            Connected accounts successfully retrieved.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"users/{jsonable_encoder(id)}/connected-accounts",
            method="GET",
            params={
                "from": from_,
                "take": take,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    ListUserConnectedAccountsResponseContent,
                    parse_obj_as(
                        type_=ListUserConnectedAccountsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.connected_accounts
                _parsed_next = _parsed_response.next
                _has_next = _parsed_next is not None and _parsed_next != ""

                async def _get_next():
                    return await self.list(
                        id,
                        from_=_parsed_next,
                        take=take,
                        request_options=request_options,
                    )

                return AsyncPager(has_next=_has_next, items=_items, get_next=_get_next, response=_parsed_response)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
