# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.federated_connection_token_set import FederatedConnectionTokenSet
from .raw_client import AsyncRawFederatedConnectionsTokensetsClient, RawFederatedConnectionsTokensetsClient


class FederatedConnectionsTokensetsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawFederatedConnectionsTokensetsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawFederatedConnectionsTokensetsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawFederatedConnectionsTokensetsClient
        """
        return self._raw_client

    def list(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[FederatedConnectionTokenSet]:
        """
        List active federated connections tokensets for a provided user

        Parameters
        ----------
        id : str
            User identifier

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[FederatedConnectionTokenSet]
            Flows successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.users.federated_connections_tokensets.list(
            id="id",
        )
        """
        _response = self._raw_client.list(id, request_options=request_options)
        return _response.data

    def delete(self, id: str, tokenset_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        id : str
            Id of the user that owns the tokenset

        tokenset_id : str
            The tokenset id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.users.federated_connections_tokensets.delete(
            id="id",
            tokenset_id="tokenset_id",
        )
        """
        _response = self._raw_client.delete(id, tokenset_id, request_options=request_options)
        return _response.data


class AsyncFederatedConnectionsTokensetsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawFederatedConnectionsTokensetsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawFederatedConnectionsTokensetsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawFederatedConnectionsTokensetsClient
        """
        return self._raw_client

    async def list(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[FederatedConnectionTokenSet]:
        """
        List active federated connections tokensets for a provided user

        Parameters
        ----------
        id : str
            User identifier

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[FederatedConnectionTokenSet]
            Flows successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.users.federated_connections_tokensets.list(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(id, request_options=request_options)
        return _response.data

    async def delete(
        self, id: str, tokenset_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        id : str
            Id of the user that owns the tokenset

        tokenset_id : str
            The tokenset id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.users.federated_connections_tokensets.delete(
                id="id",
                tokenset_id="tokenset_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, tokenset_id, request_options=request_options)
        return _response.data
