# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.user_multifactor_provider_enum import UserMultifactorProviderEnum
from .raw_client import AsyncRawMultifactorClient, RawMultifactorClient


class MultifactorClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawMultifactorClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawMultifactorClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawMultifactorClient
        """
        return self._raw_client

    def invalidate_remember_browser(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Invalidate all remembered browsers across all <a href="https://auth0.com/docs/multifactor-authentication">authentication factors</a> for a user.

        Parameters
        ----------
        id : str
            ID of the user to invalidate all remembered browsers and authentication factors for.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.users.multifactor.invalidate_remember_browser(
            id="id",
        )
        """
        _response = self._raw_client.invalidate_remember_browser(id, request_options=request_options)
        return _response.data

    def delete_provider(
        self, id: str, provider: UserMultifactorProviderEnum, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Remove a <a href="https://auth0.com/docs/multifactor-authentication">multifactor</a> authentication configuration from a user's account. This forces the user to manually reconfigure the multi-factor provider.

        Parameters
        ----------
        id : str
            ID of the user to remove a multifactor configuration from.

        provider : UserMultifactorProviderEnum
            The multi-factor provider. Supported values 'duo' or 'google-authenticator'

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.users.multifactor.delete_provider(
            id="id",
            provider="duo",
        )
        """
        _response = self._raw_client.delete_provider(id, provider, request_options=request_options)
        return _response.data


class AsyncMultifactorClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawMultifactorClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawMultifactorClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawMultifactorClient
        """
        return self._raw_client

    async def invalidate_remember_browser(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Invalidate all remembered browsers across all <a href="https://auth0.com/docs/multifactor-authentication">authentication factors</a> for a user.

        Parameters
        ----------
        id : str
            ID of the user to invalidate all remembered browsers and authentication factors for.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.users.multifactor.invalidate_remember_browser(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.invalidate_remember_browser(id, request_options=request_options)
        return _response.data

    async def delete_provider(
        self, id: str, provider: UserMultifactorProviderEnum, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Remove a <a href="https://auth0.com/docs/multifactor-authentication">multifactor</a> authentication configuration from a user's account. This forces the user to manually reconfigure the multi-factor provider.

        Parameters
        ----------
        id : str
            ID of the user to remove a multifactor configuration from.

        provider : UserMultifactorProviderEnum
            The multi-factor provider. Supported values 'duo' or 'google-authenticator'

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.users.multifactor.delete_provider(
                id="id",
                provider="duo",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_provider(id, provider, request_options=request_options)
        return _response.data
