# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.assessors_type_enum import AssessorsTypeEnum
from .raw_client import AsyncRawRiskAssessmentsClient, RawRiskAssessmentsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RiskAssessmentsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawRiskAssessmentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawRiskAssessmentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawRiskAssessmentsClient
        """
        return self._raw_client

    def clear(
        self,
        id: str,
        *,
        connection: str,
        assessors: typing.Sequence[AssessorsTypeEnum],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Clear risk assessment assessors for a specific user

        Parameters
        ----------
        id : str
            ID of the user to clear assessors for.

        connection : str
            The name of the connection containing the user whose assessors should be cleared.

        assessors : typing.Sequence[AssessorsTypeEnum]
            List of assessors to clear.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.users.risk_assessments.clear(
            id="id",
            connection="connection",
            assessors=[],
        )
        """
        _response = self._raw_client.clear(
            id, connection=connection, assessors=assessors, request_options=request_options
        )
        return _response.data


class AsyncRiskAssessmentsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawRiskAssessmentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawRiskAssessmentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawRiskAssessmentsClient
        """
        return self._raw_client

    async def clear(
        self,
        id: str,
        *,
        connection: str,
        assessors: typing.Sequence[AssessorsTypeEnum],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Clear risk assessment assessors for a specific user

        Parameters
        ----------
        id : str
            ID of the user to clear assessors for.

        connection : str
            The name of the connection containing the user whose assessors should be cleared.

        assessors : typing.Sequence[AssessorsTypeEnum]
            List of assessors to clear.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.users.risk_assessments.clear(
                id="id",
                connection="connection",
                assessors=[],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.clear(
            id, connection=connection, assessors=assessors, request_options=request_options
        )
        return _response.data
