# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pagination import AsyncPager, SyncPager
from ...core.request_options import RequestOptions
from ...types.list_user_roles_offset_paginated_response_content import ListUserRolesOffsetPaginatedResponseContent
from ...types.role import Role
from .raw_client import AsyncRawRolesClient, RawRolesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RolesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawRolesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawRolesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawRolesClient
        """
        return self._raw_client

    def list(
        self,
        id: str,
        *,
        per_page: typing.Optional[int] = 50,
        page: typing.Optional[int] = 0,
        include_totals: typing.Optional[bool] = True,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Role, ListUserRolesOffsetPaginatedResponseContent]:
        """
        Retrieve detailed list of all user roles currently assigned to a user.

        <b>Note</b>: This action retrieves all roles assigned to a user in the context of your whole tenant. To retrieve Organization-specific roles, use the following endpoint: <a href="https://auth0.com/docs/api/management/v2/organizations/get-organization-member-roles">Get user roles assigned to an Organization member</a>.

        Parameters
        ----------
        id : str
            ID of the user to list roles for.

        per_page : typing.Optional[int]
            Number of results per page.

        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Role, ListUserRolesOffsetPaginatedResponseContent]
            Roles successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.users.roles.list(
            id="id",
            per_page=1,
            page=1,
            include_totals=True,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            id, per_page=per_page, page=page, include_totals=include_totals, request_options=request_options
        )

    def assign(
        self, id: str, *, roles: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Assign one or more existing user roles to a user. For more information, review <a href="https://auth0.com/docs/manage-users/access-control/rbac">Role-Based Access Control</a>.

        <b>Note</b>: New roles cannot be created through this action. Additionally, this action is used to assign roles to a user in the context of your whole tenant. To assign roles in the context of a specific Organization, use the following endpoint: <a href="https://auth0.com/docs/api/management/v2/organizations/post-organization-member-roles">Assign user roles to an Organization member</a>.

        Parameters
        ----------
        id : str
            ID of the user to associate roles with.

        roles : typing.Sequence[str]
            List of roles IDs to associated with the user.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.users.roles.assign(
            id="id",
            roles=["roles"],
        )
        """
        _response = self._raw_client.assign(id, roles=roles, request_options=request_options)
        return _response.data

    def delete(
        self, id: str, *, roles: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Remove one or more specified user roles assigned to a user.

        <b>Note</b>: This action removes a role from a user in the context of your whole tenant. If you want to unassign a role from a user in the context of a specific Organization, use the following endpoint: <a href="https://auth0.com/docs/api/management/v2/organizations/delete-organization-member-roles">Delete user roles from an Organization member</a>.

        Parameters
        ----------
        id : str
            ID of the user to remove roles from.

        roles : typing.Sequence[str]
            List of roles IDs to remove from the user.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.users.roles.delete(
            id="id",
            roles=["roles"],
        )
        """
        _response = self._raw_client.delete(id, roles=roles, request_options=request_options)
        return _response.data


class AsyncRolesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawRolesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawRolesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawRolesClient
        """
        return self._raw_client

    async def list(
        self,
        id: str,
        *,
        per_page: typing.Optional[int] = 50,
        page: typing.Optional[int] = 0,
        include_totals: typing.Optional[bool] = True,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Role, ListUserRolesOffsetPaginatedResponseContent]:
        """
        Retrieve detailed list of all user roles currently assigned to a user.

        <b>Note</b>: This action retrieves all roles assigned to a user in the context of your whole tenant. To retrieve Organization-specific roles, use the following endpoint: <a href="https://auth0.com/docs/api/management/v2/organizations/get-organization-member-roles">Get user roles assigned to an Organization member</a>.

        Parameters
        ----------
        id : str
            ID of the user to list roles for.

        per_page : typing.Optional[int]
            Number of results per page.

        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Role, ListUserRolesOffsetPaginatedResponseContent]
            Roles successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.users.roles.list(
                id="id",
                per_page=1,
                page=1,
                include_totals=True,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            id, per_page=per_page, page=page, include_totals=include_totals, request_options=request_options
        )

    async def assign(
        self, id: str, *, roles: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Assign one or more existing user roles to a user. For more information, review <a href="https://auth0.com/docs/manage-users/access-control/rbac">Role-Based Access Control</a>.

        <b>Note</b>: New roles cannot be created through this action. Additionally, this action is used to assign roles to a user in the context of your whole tenant. To assign roles in the context of a specific Organization, use the following endpoint: <a href="https://auth0.com/docs/api/management/v2/organizations/post-organization-member-roles">Assign user roles to an Organization member</a>.

        Parameters
        ----------
        id : str
            ID of the user to associate roles with.

        roles : typing.Sequence[str]
            List of roles IDs to associated with the user.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.users.roles.assign(
                id="id",
                roles=["roles"],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.assign(id, roles=roles, request_options=request_options)
        return _response.data

    async def delete(
        self, id: str, *, roles: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Remove one or more specified user roles assigned to a user.

        <b>Note</b>: This action removes a role from a user in the context of your whole tenant. If you want to unassign a role from a user in the context of a specific Organization, use the following endpoint: <a href="https://auth0.com/docs/api/management/v2/organizations/delete-organization-member-roles">Delete user roles from an Organization member</a>.

        Parameters
        ----------
        id : str
            ID of the user to remove roles from.

        roles : typing.Sequence[str]
            List of roles IDs to remove from the user.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.users.roles.delete(
                id="id",
                roles=["roles"],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, roles=roles, request_options=request_options)
        return _response.data
