# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pagination import AsyncPager, SyncPager
from ...core.request_options import RequestOptions
from ...types.list_user_sessions_paginated_response_content import ListUserSessionsPaginatedResponseContent
from ...types.session_response_content import SessionResponseContent
from .raw_client import AsyncRawSessionsClient, RawSessionsClient


class SessionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSessionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSessionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSessionsClient
        """
        return self._raw_client

    def list(
        self,
        user_id: str,
        *,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[SessionResponseContent, ListUserSessionsPaginatedResponseContent]:
        """
        Retrieve details for a user's sessions.

        Parameters
        ----------
        user_id : str
            ID of the user to get sessions for

        from_ : typing.Optional[str]
            An optional cursor from which to start the selection (exclusive).

        take : typing.Optional[int]
            Number of results per page. Defaults to 50.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[SessionResponseContent, ListUserSessionsPaginatedResponseContent]
            The sessions were retrieved

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.users.sessions.list(
            user_id="user_id",
            from_="from",
            take=1,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(user_id, from_=from_, take=take, request_options=request_options)

    def delete(self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete all sessions for a user.

        Parameters
        ----------
        user_id : str
            ID of the user to get sessions for

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.users.sessions.delete(
            user_id="user_id",
        )
        """
        _response = self._raw_client.delete(user_id, request_options=request_options)
        return _response.data


class AsyncSessionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSessionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSessionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSessionsClient
        """
        return self._raw_client

    async def list(
        self,
        user_id: str,
        *,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[SessionResponseContent, ListUserSessionsPaginatedResponseContent]:
        """
        Retrieve details for a user's sessions.

        Parameters
        ----------
        user_id : str
            ID of the user to get sessions for

        from_ : typing.Optional[str]
            An optional cursor from which to start the selection (exclusive).

        take : typing.Optional[int]
            Number of results per page. Defaults to 50.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[SessionResponseContent, ListUserSessionsPaginatedResponseContent]
            The sessions were retrieved

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.users.sessions.list(
                user_id="user_id",
                from_="from",
                take=1,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(user_id, from_=from_, take=take, request_options=request_options)

    async def delete(self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete all sessions for a user.

        Parameters
        ----------
        user_id : str
            ID of the user to get sessions for

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.users.sessions.delete(
                user_id="user_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(user_id, request_options=request_options)
        return _response.data
