# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawVerifiableCredentialsClient, RawVerifiableCredentialsClient

if typing.TYPE_CHECKING:
    from .verification.client import AsyncVerificationClient, VerificationClient


class VerifiableCredentialsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawVerifiableCredentialsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._verification: typing.Optional[VerificationClient] = None

    @property
    def with_raw_response(self) -> RawVerifiableCredentialsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawVerifiableCredentialsClient
        """
        return self._raw_client

    @property
    def verification(self):
        if self._verification is None:
            from .verification.client import VerificationClient  # noqa: E402

            self._verification = VerificationClient(client_wrapper=self._client_wrapper)
        return self._verification


class AsyncVerifiableCredentialsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawVerifiableCredentialsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._verification: typing.Optional[AsyncVerificationClient] = None

    @property
    def with_raw_response(self) -> AsyncRawVerifiableCredentialsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawVerifiableCredentialsClient
        """
        return self._raw_client

    @property
    def verification(self):
        if self._verification is None:
            from .verification.client import AsyncVerificationClient  # noqa: E402

            self._verification = AsyncVerificationClient(client_wrapper=self._client_wrapper)
        return self._verification
