# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawVerificationClient, RawVerificationClient

if typing.TYPE_CHECKING:
    from .templates.client import AsyncTemplatesClient, TemplatesClient


class VerificationClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawVerificationClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._templates: typing.Optional[TemplatesClient] = None

    @property
    def with_raw_response(self) -> RawVerificationClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawVerificationClient
        """
        return self._raw_client

    @property
    def templates(self):
        if self._templates is None:
            from .templates.client import TemplatesClient  # noqa: E402

            self._templates = TemplatesClient(client_wrapper=self._client_wrapper)
        return self._templates


class AsyncVerificationClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawVerificationClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._templates: typing.Optional[AsyncTemplatesClient] = None

    @property
    def with_raw_response(self) -> AsyncRawVerificationClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawVerificationClient
        """
        return self._raw_client

    @property
    def templates(self):
        if self._templates is None:
            from .templates.client import AsyncTemplatesClient  # noqa: E402

            self._templates = AsyncTemplatesClient(client_wrapper=self._client_wrapper)
        return self._templates
