# This file was auto-generated by Fern from our API Definition.

import typing

from ....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ....core.pagination import AsyncPager, SyncPager
from ....core.request_options import RequestOptions
from ....types.create_verifiable_credential_template_response_content import (
    CreateVerifiableCredentialTemplateResponseContent,
)
from ....types.get_verifiable_credential_template_response_content import GetVerifiableCredentialTemplateResponseContent
from ....types.list_verifiable_credential_templates_paginated_response_content import (
    ListVerifiableCredentialTemplatesPaginatedResponseContent,
)
from ....types.mdl_presentation_request import MdlPresentationRequest
from ....types.update_verifiable_credential_template_response_content import (
    UpdateVerifiableCredentialTemplateResponseContent,
)
from ....types.verifiable_credential_template_response import VerifiableCredentialTemplateResponse
from .raw_client import AsyncRawTemplatesClient, RawTemplatesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TemplatesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTemplatesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTemplatesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTemplatesClient
        """
        return self._raw_client

    def list(
        self,
        *,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[VerifiableCredentialTemplateResponse, ListVerifiableCredentialTemplatesPaginatedResponseContent]:
        """
        List a verifiable credential templates.

        Parameters
        ----------
        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results per page. Defaults to 50.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[VerifiableCredentialTemplateResponse, ListVerifiableCredentialTemplatesPaginatedResponseContent]
            Templates successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.verifiable_credentials.verification.templates.list(
            from_="from",
            take=1,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(from_=from_, take=take, request_options=request_options)

    def create(
        self,
        *,
        name: str,
        type: str,
        dialect: str,
        presentation: MdlPresentationRequest,
        well_known_trusted_issuers: str,
        custom_certificate_authority: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateVerifiableCredentialTemplateResponseContent:
        """
        Create a verifiable credential template.

        Parameters
        ----------
        name : str

        type : str

        dialect : str

        presentation : MdlPresentationRequest

        well_known_trusted_issuers : str

        custom_certificate_authority : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateVerifiableCredentialTemplateResponseContent
            Template successfully created.

        Examples
        --------
        from auth0 import (
            Auth0,
            MdlPresentationProperties,
            MdlPresentationRequest,
            MdlPresentationRequestProperties,
        )

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.verifiable_credentials.verification.templates.create(
            name="name",
            type="type",
            dialect="dialect",
            presentation=MdlPresentationRequest(
                org_iso_18013_5_1_m_dl=MdlPresentationRequestProperties(
                    org_iso_18013_5_1=MdlPresentationProperties(),
                ),
            ),
            well_known_trusted_issuers="well_known_trusted_issuers",
        )
        """
        _response = self._raw_client.create(
            name=name,
            type=type,
            dialect=dialect,
            presentation=presentation,
            well_known_trusted_issuers=well_known_trusted_issuers,
            custom_certificate_authority=custom_certificate_authority,
            request_options=request_options,
        )
        return _response.data

    def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetVerifiableCredentialTemplateResponseContent:
        """
        Get a verifiable credential template.

        Parameters
        ----------
        id : str
            ID of the template to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetVerifiableCredentialTemplateResponseContent
            Template successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.verifiable_credentials.verification.templates.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a verifiable credential template.

        Parameters
        ----------
        id : str
            ID of the template to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.verifiable_credentials.verification.templates.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        type: typing.Optional[str] = OMIT,
        dialect: typing.Optional[str] = OMIT,
        presentation: typing.Optional[MdlPresentationRequest] = OMIT,
        well_known_trusted_issuers: typing.Optional[str] = OMIT,
        version: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateVerifiableCredentialTemplateResponseContent:
        """
        Update a verifiable credential template.

        Parameters
        ----------
        id : str
            ID of the template to retrieve.

        name : typing.Optional[str]

        type : typing.Optional[str]

        dialect : typing.Optional[str]

        presentation : typing.Optional[MdlPresentationRequest]

        well_known_trusted_issuers : typing.Optional[str]

        version : typing.Optional[float]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateVerifiableCredentialTemplateResponseContent
            Template successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.verifiable_credentials.verification.templates.update(
            id="id",
        )
        """
        _response = self._raw_client.update(
            id,
            name=name,
            type=type,
            dialect=dialect,
            presentation=presentation,
            well_known_trusted_issuers=well_known_trusted_issuers,
            version=version,
            request_options=request_options,
        )
        return _response.data


class AsyncTemplatesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTemplatesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTemplatesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTemplatesClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[VerifiableCredentialTemplateResponse, ListVerifiableCredentialTemplatesPaginatedResponseContent]:
        """
        List a verifiable credential templates.

        Parameters
        ----------
        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results per page. Defaults to 50.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[VerifiableCredentialTemplateResponse, ListVerifiableCredentialTemplatesPaginatedResponseContent]
            Templates successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.verifiable_credentials.verification.templates.list(
                from_="from",
                take=1,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(from_=from_, take=take, request_options=request_options)

    async def create(
        self,
        *,
        name: str,
        type: str,
        dialect: str,
        presentation: MdlPresentationRequest,
        well_known_trusted_issuers: str,
        custom_certificate_authority: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateVerifiableCredentialTemplateResponseContent:
        """
        Create a verifiable credential template.

        Parameters
        ----------
        name : str

        type : str

        dialect : str

        presentation : MdlPresentationRequest

        well_known_trusted_issuers : str

        custom_certificate_authority : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateVerifiableCredentialTemplateResponseContent
            Template successfully created.

        Examples
        --------
        import asyncio

        from auth0 import (
            AsyncAuth0,
            MdlPresentationProperties,
            MdlPresentationRequest,
            MdlPresentationRequestProperties,
        )

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.verifiable_credentials.verification.templates.create(
                name="name",
                type="type",
                dialect="dialect",
                presentation=MdlPresentationRequest(
                    org_iso_18013_5_1_m_dl=MdlPresentationRequestProperties(
                        org_iso_18013_5_1=MdlPresentationProperties(),
                    ),
                ),
                well_known_trusted_issuers="well_known_trusted_issuers",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name,
            type=type,
            dialect=dialect,
            presentation=presentation,
            well_known_trusted_issuers=well_known_trusted_issuers,
            custom_certificate_authority=custom_certificate_authority,
            request_options=request_options,
        )
        return _response.data

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetVerifiableCredentialTemplateResponseContent:
        """
        Get a verifiable credential template.

        Parameters
        ----------
        id : str
            ID of the template to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetVerifiableCredentialTemplateResponseContent
            Template successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.verifiable_credentials.verification.templates.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a verifiable credential template.

        Parameters
        ----------
        id : str
            ID of the template to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.verifiable_credentials.verification.templates.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        type: typing.Optional[str] = OMIT,
        dialect: typing.Optional[str] = OMIT,
        presentation: typing.Optional[MdlPresentationRequest] = OMIT,
        well_known_trusted_issuers: typing.Optional[str] = OMIT,
        version: typing.Optional[float] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateVerifiableCredentialTemplateResponseContent:
        """
        Update a verifiable credential template.

        Parameters
        ----------
        id : str
            ID of the template to retrieve.

        name : typing.Optional[str]

        type : typing.Optional[str]

        dialect : typing.Optional[str]

        presentation : typing.Optional[MdlPresentationRequest]

        well_known_trusted_issuers : typing.Optional[str]

        version : typing.Optional[float]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateVerifiableCredentialTemplateResponseContent
            Template successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.verifiable_credentials.verification.templates.update(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id,
            name=name,
            type=type,
            dialect=dialect,
            presentation=presentation,
            well_known_trusted_issuers=well_known_trusted_issuers,
            version=version,
            request_options=request_options,
        )
        return _response.data
