# coding: utf-8

"""
    ACA Services API

    API for methods pertaining to all ACA services  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from autocheckauctions.api_client import ApiClient


class VehicleApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def announcement(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Send Vehicle Announcement Data.  # noqa: E501

        Method to send vehicle announcement data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.announcement(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param list[VehicleAnnouncement] request: The announcement data (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.announcement_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
        else:
            (data) = self.announcement_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
            return data

    def announcement_with_http_info(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Send Vehicle Announcement Data.  # noqa: E501

        Method to send vehicle announcement data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.announcement_with_http_info(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param list[VehicleAnnouncement] request: The announcement data (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_api_key', 'x_autotec_id', 'request']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method announcement" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `announcement`")  # noqa: E501
        # verify the required parameter 'x_autotec_id' is set
        if ('x_autotec_id' not in params or
                params['x_autotec_id'] is None):
            raise ValueError("Missing the required parameter `x_autotec_id` when calling `announcement`")  # noqa: E501
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `announcement`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_api_key' in params:
            header_params['x-api-key'] = params['x_api_key']  # noqa: E501
        if 'x_autotec_id' in params:
            header_params['x-autotec-id'] = params['x_autotec_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['CustomerAuthorizer', 'api_key']  # noqa: E501

        return self.api_client.call_api(
            '/vehicle/announcement', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
