# coding: utf-8

"""
    ACA Services API

    API for methods pertaining to all ACA services  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from autocheckauctions.api_client import ApiClient


class VehicleHistoryApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def history_accident(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Historical Accident Activity for Requested Vehicles  # noqa: E501

        Method to retrieve accident history for a list of vehicles.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.history_accident(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param HistoryRequest request: The vehicle history request (required)
        :return: HistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.history_accident_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
        else:
            (data) = self.history_accident_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
            return data

    def history_accident_with_http_info(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Historical Accident Activity for Requested Vehicles  # noqa: E501

        Method to retrieve accident history for a list of vehicles.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.history_accident_with_http_info(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param HistoryRequest request: The vehicle history request (required)
        :return: HistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_api_key', 'x_autotec_id', 'request']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method history_accident" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `history_accident`")  # noqa: E501
        # verify the required parameter 'x_autotec_id' is set
        if ('x_autotec_id' not in params or
                params['x_autotec_id'] is None):
            raise ValueError("Missing the required parameter `x_autotec_id` when calling `history_accident`")  # noqa: E501
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `history_accident`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_api_key' in params:
            header_params['x-api-key'] = params['x_api_key']  # noqa: E501
        if 'x_autotec_id' in params:
            header_params['x-autotec-id'] = params['x_autotec_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['CustomerAuthorizer', 'api_key']  # noqa: E501

        return self.api_client.call_api(
            '/vehicle/history/accident', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HistoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def history_announcement(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Historical Auction Announcement Activity for Requested Vehicles  # noqa: E501

        Method to retrieve auction announcement history for a list of vehicles.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.history_announcement(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param HistoryRequest request: The vehicle history request (required)
        :return: HistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.history_announcement_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
        else:
            (data) = self.history_announcement_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
            return data

    def history_announcement_with_http_info(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Historical Auction Announcement Activity for Requested Vehicles  # noqa: E501

        Method to retrieve auction announcement history for a list of vehicles.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.history_announcement_with_http_info(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param HistoryRequest request: The vehicle history request (required)
        :return: HistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_api_key', 'x_autotec_id', 'request']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method history_announcement" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `history_announcement`")  # noqa: E501
        # verify the required parameter 'x_autotec_id' is set
        if ('x_autotec_id' not in params or
                params['x_autotec_id'] is None):
            raise ValueError("Missing the required parameter `x_autotec_id` when calling `history_announcement`")  # noqa: E501
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `history_announcement`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_api_key' in params:
            header_params['x-api-key'] = params['x_api_key']  # noqa: E501
        if 'x_autotec_id' in params:
            header_params['x-autotec-id'] = params['x_autotec_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['CustomerAuthorizer', 'api_key']  # noqa: E501

        return self.api_client.call_api(
            '/vehicle/history/announcement', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HistoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def history_canadian(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Historical Canadian Registration Activity for Requested Vehicles  # noqa: E501

        Method to retrieve Canadian registration history for a list of vehicles.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.history_canadian(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param HistoryRequest request: The vehicle history request (required)
        :return: HistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.history_canadian_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
        else:
            (data) = self.history_canadian_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
            return data

    def history_canadian_with_http_info(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Historical Canadian Registration Activity for Requested Vehicles  # noqa: E501

        Method to retrieve Canadian registration history for a list of vehicles.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.history_canadian_with_http_info(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param HistoryRequest request: The vehicle history request (required)
        :return: HistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_api_key', 'x_autotec_id', 'request']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method history_canadian" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `history_canadian`")  # noqa: E501
        # verify the required parameter 'x_autotec_id' is set
        if ('x_autotec_id' not in params or
                params['x_autotec_id'] is None):
            raise ValueError("Missing the required parameter `x_autotec_id` when calling `history_canadian`")  # noqa: E501
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `history_canadian`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_api_key' in params:
            header_params['x-api-key'] = params['x_api_key']  # noqa: E501
        if 'x_autotec_id' in params:
            header_params['x-autotec-id'] = params['x_autotec_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['CustomerAuthorizer', 'api_key']  # noqa: E501

        return self.api_client.call_api(
            '/vehicle/history/canadian', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HistoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def history_canadian_plus(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Canadian Registration Activity Plus the Most Recent US Registration Event for Requested Vehicles  # noqa: E501

        Method to retrieve Canadian registration history and the most recent US registration event for a list of vehicles.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.history_canadian_plus(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param HistoryRequest request: The vehicle history request (required)
        :return: HistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.history_canadian_plus_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
        else:
            (data) = self.history_canadian_plus_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
            return data

    def history_canadian_plus_with_http_info(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Canadian Registration Activity Plus the Most Recent US Registration Event for Requested Vehicles  # noqa: E501

        Method to retrieve Canadian registration history and the most recent US registration event for a list of vehicles.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.history_canadian_plus_with_http_info(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param HistoryRequest request: The vehicle history request (required)
        :return: HistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_api_key', 'x_autotec_id', 'request']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method history_canadian_plus" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `history_canadian_plus`")  # noqa: E501
        # verify the required parameter 'x_autotec_id' is set
        if ('x_autotec_id' not in params or
                params['x_autotec_id'] is None):
            raise ValueError("Missing the required parameter `x_autotec_id` when calling `history_canadian_plus`")  # noqa: E501
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `history_canadian_plus`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_api_key' in params:
            header_params['x-api-key'] = params['x_api_key']  # noqa: E501
        if 'x_autotec_id' in params:
            header_params['x-autotec-id'] = params['x_autotec_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['CustomerAuthorizer', 'api_key']  # noqa: E501

        return self.api_client.call_api(
            '/vehicle/history/canadian/plus', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HistoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def history_compromised(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Compromised Historical Activity for Requested Vehicles  # noqa: E501

        Method to retrieve history with compromised activity codes for a list of vehicles.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.history_compromised(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param HistoryRequest request: The vehicle history request (required)
        :return: HistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.history_compromised_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
        else:
            (data) = self.history_compromised_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
            return data

    def history_compromised_with_http_info(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Compromised Historical Activity for Requested Vehicles  # noqa: E501

        Method to retrieve history with compromised activity codes for a list of vehicles.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.history_compromised_with_http_info(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param HistoryRequest request: The vehicle history request (required)
        :return: HistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_api_key', 'x_autotec_id', 'request']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method history_compromised" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `history_compromised`")  # noqa: E501
        # verify the required parameter 'x_autotec_id' is set
        if ('x_autotec_id' not in params or
                params['x_autotec_id'] is None):
            raise ValueError("Missing the required parameter `x_autotec_id` when calling `history_compromised`")  # noqa: E501
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `history_compromised`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_api_key' in params:
            header_params['x-api-key'] = params['x_api_key']  # noqa: E501
        if 'x_autotec_id' in params:
            header_params['x-autotec-id'] = params['x_autotec_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['CustomerAuthorizer', 'api_key']  # noqa: E501

        return self.api_client.call_api(
            '/vehicle/history/compromised', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HistoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def history_disaster(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Historical Activity that has occurred within a Disaster Area for Requested Vehicles  # noqa: E501

        Method to retrieve vehicle history that has occurred within a disaster area for a list of vehicles.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.history_disaster(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param HistoryRequest request: The vehicle history request (required)
        :return: HistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.history_disaster_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
        else:
            (data) = self.history_disaster_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
            return data

    def history_disaster_with_http_info(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Historical Activity that has occurred within a Disaster Area for Requested Vehicles  # noqa: E501

        Method to retrieve vehicle history that has occurred within a disaster area for a list of vehicles.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.history_disaster_with_http_info(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param HistoryRequest request: The vehicle history request (required)
        :return: HistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_api_key', 'x_autotec_id', 'request']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method history_disaster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `history_disaster`")  # noqa: E501
        # verify the required parameter 'x_autotec_id' is set
        if ('x_autotec_id' not in params or
                params['x_autotec_id'] is None):
            raise ValueError("Missing the required parameter `x_autotec_id` when calling `history_disaster`")  # noqa: E501
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `history_disaster`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_api_key' in params:
            header_params['x-api-key'] = params['x_api_key']  # noqa: E501
        if 'x_autotec_id' in params:
            header_params['x-autotec-id'] = params['x_autotec_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['CustomerAuthorizer', 'api_key']  # noqa: E501

        return self.api_client.call_api(
            '/vehicle/history/disaster', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HistoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def history_discrepancy(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Odometer Discrepancy Activity for Requested Vehicles  # noqa: E501

        Method to retrieve odometer discrepancy history for a list of vehicles.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.history_discrepancy(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param HistoryRequest request: The vehicle history request (required)
        :return: HistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.history_discrepancy_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
        else:
            (data) = self.history_discrepancy_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
            return data

    def history_discrepancy_with_http_info(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Odometer Discrepancy Activity for Requested Vehicles  # noqa: E501

        Method to retrieve odometer discrepancy history for a list of vehicles.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.history_discrepancy_with_http_info(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param HistoryRequest request: The vehicle history request (required)
        :return: HistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_api_key', 'x_autotec_id', 'request']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method history_discrepancy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `history_discrepancy`")  # noqa: E501
        # verify the required parameter 'x_autotec_id' is set
        if ('x_autotec_id' not in params or
                params['x_autotec_id'] is None):
            raise ValueError("Missing the required parameter `x_autotec_id` when calling `history_discrepancy`")  # noqa: E501
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `history_discrepancy`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_api_key' in params:
            header_params['x-api-key'] = params['x_api_key']  # noqa: E501
        if 'x_autotec_id' in params:
            header_params['x-autotec-id'] = params['x_autotec_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['CustomerAuthorizer', 'api_key']  # noqa: E501

        return self.api_client.call_api(
            '/vehicle/history/discrepancy', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HistoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def history_exception(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Exception Activity for Requested Vehicles  # noqa: E501

        Method to retrieve exception history for a list of vehicles.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.history_exception(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param HistoryRequest request: The vehicle history request (required)
        :return: HistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.history_exception_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
        else:
            (data) = self.history_exception_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
            return data

    def history_exception_with_http_info(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Exception Activity for Requested Vehicles  # noqa: E501

        Method to retrieve exception history for a list of vehicles.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.history_exception_with_http_info(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param HistoryRequest request: The vehicle history request (required)
        :return: HistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_api_key', 'x_autotec_id', 'request']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method history_exception" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `history_exception`")  # noqa: E501
        # verify the required parameter 'x_autotec_id' is set
        if ('x_autotec_id' not in params or
                params['x_autotec_id'] is None):
            raise ValueError("Missing the required parameter `x_autotec_id` when calling `history_exception`")  # noqa: E501
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `history_exception`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_api_key' in params:
            header_params['x-api-key'] = params['x_api_key']  # noqa: E501
        if 'x_autotec_id' in params:
            header_params['x-autotec-id'] = params['x_autotec_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['CustomerAuthorizer', 'api_key']  # noqa: E501

        return self.api_client.call_api(
            '/vehicle/history/exception', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HistoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def history_full(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Historical Activity for Requested Vehicles  # noqa: E501

        Method to retrieve vehicle history and ownership data (if authorized) for a list of vehicles.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.history_full(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param HistoryRequest request: The vehicle history request (required)
        :return: HistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.history_full_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
        else:
            (data) = self.history_full_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
            return data

    def history_full_with_http_info(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Historical Activity for Requested Vehicles  # noqa: E501

        Method to retrieve vehicle history and ownership data (if authorized) for a list of vehicles.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.history_full_with_http_info(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param HistoryRequest request: The vehicle history request (required)
        :return: HistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_api_key', 'x_autotec_id', 'request']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method history_full" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `history_full`")  # noqa: E501
        # verify the required parameter 'x_autotec_id' is set
        if ('x_autotec_id' not in params or
                params['x_autotec_id'] is None):
            raise ValueError("Missing the required parameter `x_autotec_id` when calling `history_full`")  # noqa: E501
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `history_full`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_api_key' in params:
            header_params['x-api-key'] = params['x_api_key']  # noqa: E501
        if 'x_autotec_id' in params:
            header_params['x-autotec-id'] = params['x_autotec_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['CustomerAuthorizer', 'api_key']  # noqa: E501

        return self.api_client.call_api(
            '/vehicle/history/full', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HistoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def history_recall(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Recall Activity for Requested Vehicles  # noqa: E501

        Method to retrieve recall history for a list of vehicles.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.history_recall(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param HistoryRequest request: The vehicle history request (required)
        :return: HistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.history_recall_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
        else:
            (data) = self.history_recall_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
            return data

    def history_recall_with_http_info(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Recall Activity for Requested Vehicles  # noqa: E501

        Method to retrieve recall history for a list of vehicles.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.history_recall_with_http_info(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param HistoryRequest request: The vehicle history request (required)
        :return: HistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_api_key', 'x_autotec_id', 'request']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method history_recall" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `history_recall`")  # noqa: E501
        # verify the required parameter 'x_autotec_id' is set
        if ('x_autotec_id' not in params or
                params['x_autotec_id'] is None):
            raise ValueError("Missing the required parameter `x_autotec_id` when calling `history_recall`")  # noqa: E501
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `history_recall`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_api_key' in params:
            header_params['x-api-key'] = params['x_api_key']  # noqa: E501
        if 'x_autotec_id' in params:
            header_params['x-autotec-id'] = params['x_autotec_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['CustomerAuthorizer', 'api_key']  # noqa: E501

        return self.api_client.call_api(
            '/vehicle/history/recall', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HistoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def history_theft(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Theft Activity for Requested Vehicles  # noqa: E501

        Method to retrieve theft history for a list of vehicles.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.history_theft(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param HistoryRequest request: The vehicle history request (required)
        :return: HistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.history_theft_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
        else:
            (data) = self.history_theft_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
            return data

    def history_theft_with_http_info(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Theft Activity for Requested Vehicles  # noqa: E501

        Method to retrieve theft history for a list of vehicles.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.history_theft_with_http_info(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param HistoryRequest request: The vehicle history request (required)
        :return: HistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_api_key', 'x_autotec_id', 'request']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method history_theft" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `history_theft`")  # noqa: E501
        # verify the required parameter 'x_autotec_id' is set
        if ('x_autotec_id' not in params or
                params['x_autotec_id'] is None):
            raise ValueError("Missing the required parameter `x_autotec_id` when calling `history_theft`")  # noqa: E501
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `history_theft`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_api_key' in params:
            header_params['x-api-key'] = params['x_api_key']  # noqa: E501
        if 'x_autotec_id' in params:
            header_params['x-autotec-id'] = params['x_autotec_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['CustomerAuthorizer', 'api_key']  # noqa: E501

        return self.api_client.call_api(
            '/vehicle/history/theft', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HistoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
