# autocheckauctions-api-python-client
API for methods pertaining to all ACA services

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.2
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import autocheckauctions 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import autocheckauctions
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import autocheckauctions
from autocheckauctions.rest import ApiException
from pprint import pprint

# Configure API key authorization: CustomerAuthorizer
autocheckauctions.configuration.api_key['Unused'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# autocheckauctions.configuration.api_key_prefix['Unused'] = 'Bearer'
# Configure API key authorization: api_key
autocheckauctions.configuration.api_key['x-api-key'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# autocheckauctions.configuration.api_key_prefix['x-api-key'] = 'Bearer'
# create an instance of the API class
api_instance = autocheckauctions.VehicleApi()
x_api_key = 'x_api_key_example' # str | the AutoTec assigned authentication credential for the calling customer
x_autotec_id = 'x_autotec_id_example' # str | the AutoTec assigned identification id for the calling customer
request = [autocheckauctions.VehicleAnnouncement()] # list[VehicleAnnouncement] | The announcement data

try:
    # Send Vehicle Announcement Data.
    api_response = api_instance.announcement(x_api_key, x_autotec_id, request)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling VehicleApi->announcement: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://aca.dev.autotec.com/api/*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*VehicleApi* | [**announcement**](docs/VehicleApi.md#announcement) | **POST** /vehicle/announcement | Send Vehicle Announcement Data.
*VehicleHistoryApi* | [**autocheck_lite_report_summary**](docs/VehicleHistoryApi.md#autocheck_lite_report_summary) | **POST** /vehicle/history/summary | Retrieve Historical Accident Activity for Requested Vehicles
*VehicleHistoryApi* | [**history_accident**](docs/VehicleHistoryApi.md#history_accident) | **POST** /vehicle/history/accident | Retrieve Historical Accident Activity for Requested Vehicles
*VehicleHistoryApi* | [**history_announcement**](docs/VehicleHistoryApi.md#history_announcement) | **POST** /vehicle/history/announcement | Retrieve Historical Auction Announcement Activity for Requested Vehicles
*VehicleHistoryApi* | [**history_canadian**](docs/VehicleHistoryApi.md#history_canadian) | **POST** /vehicle/history/canadian | Retrieve Historical Canadian Registration Activity for Requested Vehicles
*VehicleHistoryApi* | [**history_canadian_plus**](docs/VehicleHistoryApi.md#history_canadian_plus) | **POST** /vehicle/history/canadian/plus | Retrieve Canadian Registration Activity Plus the Most Recent US Registration Event for Requested Vehicles
*VehicleHistoryApi* | [**history_compromised**](docs/VehicleHistoryApi.md#history_compromised) | **POST** /vehicle/history/compromised | Retrieve Compromised Historical Activity for Requested Vehicles
*VehicleHistoryApi* | [**history_disaster**](docs/VehicleHistoryApi.md#history_disaster) | **POST** /vehicle/history/disaster | Retrieve Historical Activity that has occurred within a Disaster Area for Requested Vehicles
*VehicleHistoryApi* | [**history_discrepancy**](docs/VehicleHistoryApi.md#history_discrepancy) | **POST** /vehicle/history/discrepancy | Retrieve Odometer Discrepancy Activity for Requested Vehicles
*VehicleHistoryApi* | [**history_exception**](docs/VehicleHistoryApi.md#history_exception) | **POST** /vehicle/history/exception | Retrieve Exception Activity for Requested Vehicles
*VehicleHistoryApi* | [**history_full**](docs/VehicleHistoryApi.md#history_full) | **POST** /vehicle/history/full | Retrieve Historical Activity for Requested Vehicles
*VehicleHistoryApi* | [**history_recall**](docs/VehicleHistoryApi.md#history_recall) | **POST** /vehicle/history/recall | Retrieve Recall Activity for Requested Vehicles
*VehicleHistoryApi* | [**history_theft**](docs/VehicleHistoryApi.md#history_theft) | **POST** /vehicle/history/theft | Retrieve Theft Activity for Requested Vehicles
*DefaultApi* | [**vehicle_announcement_options**](docs/DefaultApi.md#vehicle_announcement_options) | **OPTIONS** /vehicle/announcement | 
*DefaultApi* | [**vehicle_history_accident_options**](docs/DefaultApi.md#vehicle_history_accident_options) | **OPTIONS** /vehicle/history/accident | 
*DefaultApi* | [**vehicle_history_announcement_options**](docs/DefaultApi.md#vehicle_history_announcement_options) | **OPTIONS** /vehicle/history/announcement | 
*DefaultApi* | [**vehicle_history_canadian_options**](docs/DefaultApi.md#vehicle_history_canadian_options) | **OPTIONS** /vehicle/history/canadian | 
*DefaultApi* | [**vehicle_history_canadian_plus_options**](docs/DefaultApi.md#vehicle_history_canadian_plus_options) | **OPTIONS** /vehicle/history/canadian/plus | 
*DefaultApi* | [**vehicle_history_compromised_options**](docs/DefaultApi.md#vehicle_history_compromised_options) | **OPTIONS** /vehicle/history/compromised | 
*DefaultApi* | [**vehicle_history_disaster_options**](docs/DefaultApi.md#vehicle_history_disaster_options) | **OPTIONS** /vehicle/history/disaster | 
*DefaultApi* | [**vehicle_history_discrepancy_options**](docs/DefaultApi.md#vehicle_history_discrepancy_options) | **OPTIONS** /vehicle/history/discrepancy | 
*DefaultApi* | [**vehicle_history_exception_options**](docs/DefaultApi.md#vehicle_history_exception_options) | **OPTIONS** /vehicle/history/exception | 
*DefaultApi* | [**vehicle_history_full_options**](docs/DefaultApi.md#vehicle_history_full_options) | **OPTIONS** /vehicle/history/full | 
*DefaultApi* | [**vehicle_history_recall_options**](docs/DefaultApi.md#vehicle_history_recall_options) | **OPTIONS** /vehicle/history/recall | 
*DefaultApi* | [**vehicle_history_summary_options**](docs/DefaultApi.md#vehicle_history_summary_options) | **OPTIONS** /vehicle/history/summary | 
*DefaultApi* | [**vehicle_history_theft_options**](docs/DefaultApi.md#vehicle_history_theft_options) | **OPTIONS** /vehicle/history/theft | 


## Documentation For Models

 - [Empty](docs/Empty.md)
 - [HistoryRecord](docs/HistoryRecord.md)
 - [HistoryRequest](docs/HistoryRequest.md)
 - [HistoryResponse](docs/HistoryResponse.md)
 - [RecallRecord](docs/RecallRecord.md)
 - [UnprocessedHistoryRequests](docs/UnprocessedHistoryRequests.md)
 - [Vehicle](docs/Vehicle.md)
 - [VehicleAnnouncement](docs/VehicleAnnouncement.md)
 - [VehicleHistory](docs/VehicleHistory.md)
 - [VehicleInformation](docs/VehicleInformation.md)
 - [VehicleOwnershipActivity](docs/VehicleOwnershipActivity.md)
 - [VehicleRecall](docs/VehicleRecall.md)
 - [VehicleRequestAttribute](docs/VehicleRequestAttribute.md)
 - [VehicleScoring](docs/VehicleScoring.md)


## Documentation For Authorization


## CustomerAuthorizer

- **Type**: API key
- **API key parameter name**: Unused
- **Location**: HTTP header

## api_key

- **Type**: API key
- **API key parameter name**: x-api-key
- **Location**: HTTP header


## Author



