# coding: utf-8

"""
    ACA Services API

    API for methods pertaining to all ACA services  # noqa: E501

    OpenAPI spec version: 1.0.3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class VehicleAnnouncement(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'brand_date': 'date',
        'city': 'str',
        'dealer_number': 'str',
        'flag': 'list[str]',
        'odo_date': 'date',
        'reading': 'int',
        'sale_number': 'str',
        'state': 'str',
        'uom': 'str',
        'vin': 'str'
    }

    attribute_map = {
        'brand_date': 'brandDate',
        'city': 'city',
        'dealer_number': 'dealerNumber',
        'flag': 'flag',
        'odo_date': 'odoDate',
        'reading': 'reading',
        'sale_number': 'saleNumber',
        'state': 'state',
        'uom': 'uom',
        'vin': 'vin'
    }

    def __init__(self, brand_date=None, city=None, dealer_number=None, flag=None, odo_date=None, reading=None, sale_number=None, state=None, uom=None, vin=None):  # noqa: E501
        """VehicleAnnouncement - a model defined in Swagger"""  # noqa: E501

        self._brand_date = None
        self._city = None
        self._dealer_number = None
        self._flag = None
        self._odo_date = None
        self._reading = None
        self._sale_number = None
        self._state = None
        self._uom = None
        self._vin = None
        self.discriminator = None

        if brand_date is not None:
            self.brand_date = brand_date
        if city is not None:
            self.city = city
        if dealer_number is not None:
            self.dealer_number = dealer_number
        if flag is not None:
            self.flag = flag
        if odo_date is not None:
            self.odo_date = odo_date
        if reading is not None:
            self.reading = reading
        if sale_number is not None:
            self.sale_number = sale_number
        if state is not None:
            self.state = state
        if uom is not None:
            self.uom = uom
        if vin is not None:
            self.vin = vin

    @property
    def brand_date(self):
        """Gets the brand_date of this VehicleAnnouncement.  # noqa: E501

        the date the announcement occurred  # noqa: E501

        :return: The brand_date of this VehicleAnnouncement.  # noqa: E501
        :rtype: date
        """
        return self._brand_date

    @brand_date.setter
    def brand_date(self, brand_date):
        """Sets the brand_date of this VehicleAnnouncement.

        the date the announcement occurred  # noqa: E501

        :param brand_date: The brand_date of this VehicleAnnouncement.  # noqa: E501
        :type: date
        """

        self._brand_date = brand_date

    @property
    def city(self):
        """Gets the city of this VehicleAnnouncement.  # noqa: E501

        the city the announcement occurred in  # noqa: E501

        :return: The city of this VehicleAnnouncement.  # noqa: E501
        :rtype: str
        """
        return self._city

    @city.setter
    def city(self, city):
        """Sets the city of this VehicleAnnouncement.

        the city the announcement occurred in  # noqa: E501

        :param city: The city of this VehicleAnnouncement.  # noqa: E501
        :type: str
        """

        self._city = city

    @property
    def dealer_number(self):
        """Gets the dealer_number of this VehicleAnnouncement.  # noqa: E501

        the dealer number assigned by the auction  # noqa: E501

        :return: The dealer_number of this VehicleAnnouncement.  # noqa: E501
        :rtype: str
        """
        return self._dealer_number

    @dealer_number.setter
    def dealer_number(self, dealer_number):
        """Sets the dealer_number of this VehicleAnnouncement.

        the dealer number assigned by the auction  # noqa: E501

        :param dealer_number: The dealer_number of this VehicleAnnouncement.  # noqa: E501
        :type: str
        """

        self._dealer_number = dealer_number

    @property
    def flag(self):
        """Gets the flag of this VehicleAnnouncement.  # noqa: E501

        the announcement brand (See Announcement Flag Definitions Document)  # noqa: E501

        :return: The flag of this VehicleAnnouncement.  # noqa: E501
        :rtype: list[str]
        """
        return self._flag

    @flag.setter
    def flag(self, flag):
        """Sets the flag of this VehicleAnnouncement.

        the announcement brand (See Announcement Flag Definitions Document)  # noqa: E501

        :param flag: The flag of this VehicleAnnouncement.  # noqa: E501
        :type: list[str]
        """
        allowed_values = ["A", "B", "B2", "B3", "B4", "B5", "B6", "B7", "B8", "B9", "C", "C1", "C2", "C3", "C4", "C5", "C6", "C7", "C8", "C9", "D", "D1", "D2", "D3", "D4", "D5", "D6", "D7", "D8", "D9", "E", "E2", "E3", "E4", "E5", "E6", "E7", "E8", "E9", "F", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "G", "G1", "G2", "G3", "G4", "G5", "H", "J", "K", "M", "N", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y"]  # noqa: E501
        if not set(flag).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `flag` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(flag) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._flag = flag

    @property
    def odo_date(self):
        """Gets the odo_date of this VehicleAnnouncement.  # noqa: E501

        the date of the odometer reading  # noqa: E501

        :return: The odo_date of this VehicleAnnouncement.  # noqa: E501
        :rtype: date
        """
        return self._odo_date

    @odo_date.setter
    def odo_date(self, odo_date):
        """Sets the odo_date of this VehicleAnnouncement.

        the date of the odometer reading  # noqa: E501

        :param odo_date: The odo_date of this VehicleAnnouncement.  # noqa: E501
        :type: date
        """

        self._odo_date = odo_date

    @property
    def reading(self):
        """Gets the reading of this VehicleAnnouncement.  # noqa: E501

        the actual mileage of the vehicle  # noqa: E501

        :return: The reading of this VehicleAnnouncement.  # noqa: E501
        :rtype: int
        """
        return self._reading

    @reading.setter
    def reading(self, reading):
        """Sets the reading of this VehicleAnnouncement.

        the actual mileage of the vehicle  # noqa: E501

        :param reading: The reading of this VehicleAnnouncement.  # noqa: E501
        :type: int
        """

        self._reading = reading

    @property
    def sale_number(self):
        """Gets the sale_number of this VehicleAnnouncement.  # noqa: E501

        the lane assignment and run number assigned to the vehicle from the auction  # noqa: E501

        :return: The sale_number of this VehicleAnnouncement.  # noqa: E501
        :rtype: str
        """
        return self._sale_number

    @sale_number.setter
    def sale_number(self, sale_number):
        """Sets the sale_number of this VehicleAnnouncement.

        the lane assignment and run number assigned to the vehicle from the auction  # noqa: E501

        :param sale_number: The sale_number of this VehicleAnnouncement.  # noqa: E501
        :type: str
        """

        self._sale_number = sale_number

    @property
    def state(self):
        """Gets the state of this VehicleAnnouncement.  # noqa: E501

        the state the announcement occurred in, ex: AL, AK, FL, GA, NY, etc  # noqa: E501

        :return: The state of this VehicleAnnouncement.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this VehicleAnnouncement.

        the state the announcement occurred in, ex: AL, AK, FL, GA, NY, etc  # noqa: E501

        :param state: The state of this VehicleAnnouncement.  # noqa: E501
        :type: str
        """
        if state is not None and len(state) > 2:
            raise ValueError("Invalid value for `state`, length must be less than or equal to `2`")  # noqa: E501

        self._state = state

    @property
    def uom(self):
        """Gets the uom of this VehicleAnnouncement.  # noqa: E501

        the odometer unit of measurement  # noqa: E501

        :return: The uom of this VehicleAnnouncement.  # noqa: E501
        :rtype: str
        """
        return self._uom

    @uom.setter
    def uom(self, uom):
        """Sets the uom of this VehicleAnnouncement.

        the odometer unit of measurement  # noqa: E501

        :param uom: The uom of this VehicleAnnouncement.  # noqa: E501
        :type: str
        """
        allowed_values = ["M", "K"]  # noqa: E501
        if uom not in allowed_values:
            raise ValueError(
                "Invalid value for `uom` ({0}), must be one of {1}"  # noqa: E501
                .format(uom, allowed_values)
            )

        self._uom = uom

    @property
    def vin(self):
        """Gets the vin of this VehicleAnnouncement.  # noqa: E501

        Vehicle Identification Number  # noqa: E501

        :return: The vin of this VehicleAnnouncement.  # noqa: E501
        :rtype: str
        """
        return self._vin

    @vin.setter
    def vin(self, vin):
        """Sets the vin of this VehicleAnnouncement.

        Vehicle Identification Number  # noqa: E501

        :param vin: The vin of this VehicleAnnouncement.  # noqa: E501
        :type: str
        """

        self._vin = vin

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VehicleAnnouncement):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
