# coding: utf-8

"""
    ACA Services API

    API for methods pertaining to all ACA services  # noqa: E501

    OpenAPI spec version: 1.4.3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from autocheckauctions.api_client import ApiClient


class BatchApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def batch_accident(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Batch Token  # noqa: E501

        Method to retrieve ACA batch token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.batch_accident(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param BatchRequest request: The batch report request (required)
        :return: BatchReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.batch_accident_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
        else:
            (data) = self.batch_accident_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
            return data

    def batch_accident_with_http_info(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Batch Token  # noqa: E501

        Method to retrieve ACA batch token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.batch_accident_with_http_info(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param BatchRequest request: The batch report request (required)
        :return: BatchReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_api_key', 'x_autotec_id', 'request']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_accident" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `batch_accident`")  # noqa: E501
        # verify the required parameter 'x_autotec_id' is set
        if ('x_autotec_id' not in params or
                params['x_autotec_id'] is None):
            raise ValueError("Missing the required parameter `x_autotec_id` when calling `batch_accident`")  # noqa: E501
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `batch_accident`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_api_key' in params:
            header_params['x-api-key'] = params['x_api_key']  # noqa: E501
        if 'x_autotec_id' in params:
            header_params['x-autotec-id'] = params['x_autotec_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['CustomerAuthorizer', 'api_key']  # noqa: E501

        return self.api_client.call_api(
            '/batch/vehicle/history/accident', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchReportResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_announcement(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Batch Token  # noqa: E501

        Method to retrieve ACA batch token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.batch_announcement(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param BatchRequest request: The batch report request (required)
        :return: BatchReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.batch_announcement_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
        else:
            (data) = self.batch_announcement_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
            return data

    def batch_announcement_with_http_info(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Batch Token  # noqa: E501

        Method to retrieve ACA batch token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.batch_announcement_with_http_info(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param BatchRequest request: The batch report request (required)
        :return: BatchReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_api_key', 'x_autotec_id', 'request']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_announcement" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `batch_announcement`")  # noqa: E501
        # verify the required parameter 'x_autotec_id' is set
        if ('x_autotec_id' not in params or
                params['x_autotec_id'] is None):
            raise ValueError("Missing the required parameter `x_autotec_id` when calling `batch_announcement`")  # noqa: E501
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `batch_announcement`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_api_key' in params:
            header_params['x-api-key'] = params['x_api_key']  # noqa: E501
        if 'x_autotec_id' in params:
            header_params['x-autotec-id'] = params['x_autotec_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['CustomerAuthorizer', 'api_key']  # noqa: E501

        return self.api_client.call_api(
            '/batch/vehicle/history/announcement', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchReportResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_canadian(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Batch Token  # noqa: E501

        Method to retrieve ACA batch token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.batch_canadian(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param BatchRequest request: The batch report request (required)
        :return: BatchReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.batch_canadian_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
        else:
            (data) = self.batch_canadian_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
            return data

    def batch_canadian_with_http_info(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Batch Token  # noqa: E501

        Method to retrieve ACA batch token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.batch_canadian_with_http_info(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param BatchRequest request: The batch report request (required)
        :return: BatchReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_api_key', 'x_autotec_id', 'request']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_canadian" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `batch_canadian`")  # noqa: E501
        # verify the required parameter 'x_autotec_id' is set
        if ('x_autotec_id' not in params or
                params['x_autotec_id'] is None):
            raise ValueError("Missing the required parameter `x_autotec_id` when calling `batch_canadian`")  # noqa: E501
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `batch_canadian`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_api_key' in params:
            header_params['x-api-key'] = params['x_api_key']  # noqa: E501
        if 'x_autotec_id' in params:
            header_params['x-autotec-id'] = params['x_autotec_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['CustomerAuthorizer', 'api_key']  # noqa: E501

        return self.api_client.call_api(
            '/batch/vehicle/history/canadian', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchReportResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_canadian_plus(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Batch Token  # noqa: E501

        Method to retrieve ACA batch token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.batch_canadian_plus(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param BatchRequest request: The batch report request (required)
        :return: BatchReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.batch_canadian_plus_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
        else:
            (data) = self.batch_canadian_plus_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
            return data

    def batch_canadian_plus_with_http_info(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Batch Token  # noqa: E501

        Method to retrieve ACA batch token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.batch_canadian_plus_with_http_info(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param BatchRequest request: The batch report request (required)
        :return: BatchReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_api_key', 'x_autotec_id', 'request']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_canadian_plus" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `batch_canadian_plus`")  # noqa: E501
        # verify the required parameter 'x_autotec_id' is set
        if ('x_autotec_id' not in params or
                params['x_autotec_id'] is None):
            raise ValueError("Missing the required parameter `x_autotec_id` when calling `batch_canadian_plus`")  # noqa: E501
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `batch_canadian_plus`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_api_key' in params:
            header_params['x-api-key'] = params['x_api_key']  # noqa: E501
        if 'x_autotec_id' in params:
            header_params['x-autotec-id'] = params['x_autotec_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['CustomerAuthorizer', 'api_key']  # noqa: E501

        return self.api_client.call_api(
            '/batch/vehicle/history/canadian/plus', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchReportResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_compromised(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Batch Token  # noqa: E501

        Method to retrieve ACA batch token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.batch_compromised(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param BatchRequest request: The batch report request (required)
        :return: BatchReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.batch_compromised_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
        else:
            (data) = self.batch_compromised_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
            return data

    def batch_compromised_with_http_info(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Batch Token  # noqa: E501

        Method to retrieve ACA batch token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.batch_compromised_with_http_info(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param BatchRequest request: The batch report request (required)
        :return: BatchReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_api_key', 'x_autotec_id', 'request']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_compromised" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `batch_compromised`")  # noqa: E501
        # verify the required parameter 'x_autotec_id' is set
        if ('x_autotec_id' not in params or
                params['x_autotec_id'] is None):
            raise ValueError("Missing the required parameter `x_autotec_id` when calling `batch_compromised`")  # noqa: E501
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `batch_compromised`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_api_key' in params:
            header_params['x-api-key'] = params['x_api_key']  # noqa: E501
        if 'x_autotec_id' in params:
            header_params['x-autotec-id'] = params['x_autotec_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['CustomerAuthorizer', 'api_key']  # noqa: E501

        return self.api_client.call_api(
            '/batch/vehicle/history/compromised', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchReportResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_disaster(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Batch Token  # noqa: E501

        Method to retrieve ACA batch token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.batch_disaster(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param BatchRequest request: The batch report request (required)
        :return: BatchReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.batch_disaster_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
        else:
            (data) = self.batch_disaster_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
            return data

    def batch_disaster_with_http_info(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Batch Token  # noqa: E501

        Method to retrieve ACA batch token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.batch_disaster_with_http_info(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param BatchRequest request: The batch report request (required)
        :return: BatchReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_api_key', 'x_autotec_id', 'request']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_disaster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `batch_disaster`")  # noqa: E501
        # verify the required parameter 'x_autotec_id' is set
        if ('x_autotec_id' not in params or
                params['x_autotec_id'] is None):
            raise ValueError("Missing the required parameter `x_autotec_id` when calling `batch_disaster`")  # noqa: E501
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `batch_disaster`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_api_key' in params:
            header_params['x-api-key'] = params['x_api_key']  # noqa: E501
        if 'x_autotec_id' in params:
            header_params['x-autotec-id'] = params['x_autotec_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['CustomerAuthorizer', 'api_key']  # noqa: E501

        return self.api_client.call_api(
            '/batch/vehicle/history/disaster', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchReportResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_discrepancy(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Batch Token  # noqa: E501

        Method to retrieve ACA batch token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.batch_discrepancy(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param BatchRequest request: The batch report request (required)
        :return: BatchReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.batch_discrepancy_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
        else:
            (data) = self.batch_discrepancy_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
            return data

    def batch_discrepancy_with_http_info(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Batch Token  # noqa: E501

        Method to retrieve ACA batch token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.batch_discrepancy_with_http_info(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param BatchRequest request: The batch report request (required)
        :return: BatchReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_api_key', 'x_autotec_id', 'request']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_discrepancy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `batch_discrepancy`")  # noqa: E501
        # verify the required parameter 'x_autotec_id' is set
        if ('x_autotec_id' not in params or
                params['x_autotec_id'] is None):
            raise ValueError("Missing the required parameter `x_autotec_id` when calling `batch_discrepancy`")  # noqa: E501
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `batch_discrepancy`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_api_key' in params:
            header_params['x-api-key'] = params['x_api_key']  # noqa: E501
        if 'x_autotec_id' in params:
            header_params['x-autotec-id'] = params['x_autotec_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['CustomerAuthorizer', 'api_key']  # noqa: E501

        return self.api_client.call_api(
            '/batch/vehicle/history/discrepancy', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchReportResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_exception(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Batch Token  # noqa: E501

        Method to retrieve ACA batch token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.batch_exception(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param BatchRequest request: The batch report request (required)
        :return: BatchReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.batch_exception_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
        else:
            (data) = self.batch_exception_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
            return data

    def batch_exception_with_http_info(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Batch Token  # noqa: E501

        Method to retrieve ACA batch token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.batch_exception_with_http_info(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param BatchRequest request: The batch report request (required)
        :return: BatchReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_api_key', 'x_autotec_id', 'request']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_exception" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `batch_exception`")  # noqa: E501
        # verify the required parameter 'x_autotec_id' is set
        if ('x_autotec_id' not in params or
                params['x_autotec_id'] is None):
            raise ValueError("Missing the required parameter `x_autotec_id` when calling `batch_exception`")  # noqa: E501
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `batch_exception`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_api_key' in params:
            header_params['x-api-key'] = params['x_api_key']  # noqa: E501
        if 'x_autotec_id' in params:
            header_params['x-autotec-id'] = params['x_autotec_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['CustomerAuthorizer', 'api_key']  # noqa: E501

        return self.api_client.call_api(
            '/batch/vehicle/history/exception', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchReportResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_full(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Batch Token  # noqa: E501

        Method to retrieve ACA batch token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.batch_full(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param BatchRequest request: The batch report request (required)
        :return: BatchReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.batch_full_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
        else:
            (data) = self.batch_full_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
            return data

    def batch_full_with_http_info(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Batch Token  # noqa: E501

        Method to retrieve ACA batch token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.batch_full_with_http_info(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param BatchRequest request: The batch report request (required)
        :return: BatchReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_api_key', 'x_autotec_id', 'request']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_full" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `batch_full`")  # noqa: E501
        # verify the required parameter 'x_autotec_id' is set
        if ('x_autotec_id' not in params or
                params['x_autotec_id'] is None):
            raise ValueError("Missing the required parameter `x_autotec_id` when calling `batch_full`")  # noqa: E501
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `batch_full`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_api_key' in params:
            header_params['x-api-key'] = params['x_api_key']  # noqa: E501
        if 'x_autotec_id' in params:
            header_params['x-autotec-id'] = params['x_autotec_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['CustomerAuthorizer', 'api_key']  # noqa: E501

        return self.api_client.call_api(
            '/batch/vehicle/history/full', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchReportResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_recall(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Batch Token  # noqa: E501

        Method to retrieve ACA batch token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.batch_recall(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param BatchRequest request: The batch report request (required)
        :return: BatchReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.batch_recall_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
        else:
            (data) = self.batch_recall_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
            return data

    def batch_recall_with_http_info(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Batch Token  # noqa: E501

        Method to retrieve ACA batch token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.batch_recall_with_http_info(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param BatchRequest request: The batch report request (required)
        :return: BatchReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_api_key', 'x_autotec_id', 'request']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_recall" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `batch_recall`")  # noqa: E501
        # verify the required parameter 'x_autotec_id' is set
        if ('x_autotec_id' not in params or
                params['x_autotec_id'] is None):
            raise ValueError("Missing the required parameter `x_autotec_id` when calling `batch_recall`")  # noqa: E501
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `batch_recall`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_api_key' in params:
            header_params['x-api-key'] = params['x_api_key']  # noqa: E501
        if 'x_autotec_id' in params:
            header_params['x-autotec-id'] = params['x_autotec_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['CustomerAuthorizer', 'api_key']  # noqa: E501

        return self.api_client.call_api(
            '/batch/vehicle/history/recall', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchReportResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_retrieve(self, x_api_key, x_autotec_id, token, **kwargs):  # noqa: E501
        """Retrieve Presigned URL  # noqa: E501

        Method to retrieve the Presigned URLs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.batch_retrieve(x_api_key, x_autotec_id, token, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param str token: Token QSP (required)
        :return: BatchResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.batch_retrieve_with_http_info(x_api_key, x_autotec_id, token, **kwargs)  # noqa: E501
        else:
            (data) = self.batch_retrieve_with_http_info(x_api_key, x_autotec_id, token, **kwargs)  # noqa: E501
            return data

    def batch_retrieve_with_http_info(self, x_api_key, x_autotec_id, token, **kwargs):  # noqa: E501
        """Retrieve Presigned URL  # noqa: E501

        Method to retrieve the Presigned URLs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.batch_retrieve_with_http_info(x_api_key, x_autotec_id, token, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param str token: Token QSP (required)
        :return: BatchResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_api_key', 'x_autotec_id', 'token']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_retrieve" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `batch_retrieve`")  # noqa: E501
        # verify the required parameter 'x_autotec_id' is set
        if ('x_autotec_id' not in params or
                params['x_autotec_id'] is None):
            raise ValueError("Missing the required parameter `x_autotec_id` when calling `batch_retrieve`")  # noqa: E501
        # verify the required parameter 'token' is set
        if ('token' not in params or
                params['token'] is None):
            raise ValueError("Missing the required parameter `token` when calling `batch_retrieve`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501

        header_params = {}
        if 'x_api_key' in params:
            header_params['x-api-key'] = params['x_api_key']  # noqa: E501
        if 'x_autotec_id' in params:
            header_params['x-autotec-id'] = params['x_autotec_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['CustomerAuthorizer', 'api_key']  # noqa: E501

        return self.api_client.call_api(
            '/batch/retrieve', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_summary(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Batch Token  # noqa: E501

        Method to retrieve ACA batch token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.batch_summary(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param BatchRequest request: The batch report request (required)
        :return: BatchReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.batch_summary_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
        else:
            (data) = self.batch_summary_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
            return data

    def batch_summary_with_http_info(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Batch Token  # noqa: E501

        Method to retrieve ACA batch token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.batch_summary_with_http_info(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param BatchRequest request: The batch report request (required)
        :return: BatchReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_api_key', 'x_autotec_id', 'request']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_summary" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `batch_summary`")  # noqa: E501
        # verify the required parameter 'x_autotec_id' is set
        if ('x_autotec_id' not in params or
                params['x_autotec_id'] is None):
            raise ValueError("Missing the required parameter `x_autotec_id` when calling `batch_summary`")  # noqa: E501
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `batch_summary`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_api_key' in params:
            header_params['x-api-key'] = params['x_api_key']  # noqa: E501
        if 'x_autotec_id' in params:
            header_params['x-autotec-id'] = params['x_autotec_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['CustomerAuthorizer', 'api_key']  # noqa: E501

        return self.api_client.call_api(
            '/batch/vehicle/history/summary', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchReportResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def batch_theft(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Batch Token  # noqa: E501

        Method to retrieve ACA batch token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.batch_theft(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param BatchRequest request: The batch report request (required)
        :return: BatchReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.batch_theft_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
        else:
            (data) = self.batch_theft_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
            return data

    def batch_theft_with_http_info(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Retrieve Batch Token  # noqa: E501

        Method to retrieve ACA batch token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.batch_theft_with_http_info(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param BatchRequest request: The batch report request (required)
        :return: BatchReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_api_key', 'x_autotec_id', 'request']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_theft" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `batch_theft`")  # noqa: E501
        # verify the required parameter 'x_autotec_id' is set
        if ('x_autotec_id' not in params or
                params['x_autotec_id'] is None):
            raise ValueError("Missing the required parameter `x_autotec_id` when calling `batch_theft`")  # noqa: E501
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `batch_theft`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_api_key' in params:
            header_params['x-api-key'] = params['x_api_key']  # noqa: E501
        if 'x_autotec_id' in params:
            header_params['x-autotec-id'] = params['x_autotec_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['CustomerAuthorizer', 'api_key']  # noqa: E501

        return self.api_client.call_api(
            '/batch/vehicle/history/theft', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchReportResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
