# automation-test-no-submodules-python-sdk

SDKs (no submodules) to test automation workflows.


[![PyPI](https://img.shields.io/badge/PyPI-v1.0.1-blue)](https://pypi.org/project/automation-test-no-submodules-python-sdk/1.0.1)
[![GitHub last commit](https://img.shields.io/github/last-commit/eddiechayes/automation-test/tree/main/python.svg)](https://github.com/eddiechayes/automation-test/tree/main/python/commits)

## Requirements

Python >=3.7

## Installing

```sh
pip install automation-test-no-submodules-python-sdk==1.0.1
```

## Getting Started

```python
from pprint import pprint
from automation_test_no_submodules import AutomationTestNoSubmodules, ApiException

automationtestnosubmodules = AutomationTestNoSubmodules()

try:
    # Get a simple greeting
    hello_response = automationtestnosubmodules.greetings.hello()
    pprint(hello_response.body)
    pprint(hello_response.body["message"])
    pprint(hello_response.headers)
    pprint(hello_response.status)
    pprint(hello_response.round_trip_time)
except ApiException as e:
    print("Exception when calling GreetingsApi.hello: %s\n" % e)
    pprint(e.body)
    pprint(e.headers)
    pprint(e.status)
    pprint(e.reason)
    pprint(e.round_trip_time)
```

## Async

`async` support is available by prepending `a` to any method.

```python
import asyncio
from pprint import pprint
from automation_test_no_submodules import AutomationTestNoSubmodules, ApiException

automationtestnosubmodules = AutomationTestNoSubmodules()


async def main():
    try:
        # Get a simple greeting
        hello_response = await automationtestnosubmodules.greetings.ahello()
        pprint(hello_response.body)
        pprint(hello_response.body["message"])
        pprint(hello_response.headers)
        pprint(hello_response.status)
        pprint(hello_response.round_trip_time)
    except ApiException as e:
        print("Exception when calling GreetingsApi.hello: %s\n" % e)
        pprint(e.body)
        pprint(e.headers)
        pprint(e.status)
        pprint(e.reason)
        pprint(e.round_trip_time)


asyncio.run(main())
```


## Documentation for API Endpoints

All URIs are relative to *http://google.com*

Tag | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*Greetings* | [**hello**](docs/apis/tags/GreetingsApi.md#hello) | **GET** /hello | Get a simple greeting


## Author
This Python package is automatically generated by [Konfig](https://konfigthis.com)
