# automation-test-with-submodule-python-sdk<a id="automation-test-with-submodule-python-sdk"></a>

SDKs (no submodules) to test automation workflows.


[![PyPI](https://img.shields.io/badge/PyPI-v1.0.9-blue)](https://pypi.org/project/automation-test-with-submodule-python-sdk/1.0.9)
[![README.md](https://img.shields.io/badge/README-Click%20Here-green)](https://github.com/eddiechayes/automation-test/tree/main/python#readme)

## Table of Contents<a id="table-of-contents"></a>

<!-- toc -->

- [Requirements](#requirements)
- [Installation](#installation)
- [Getting Started](#getting-started)
- [Async](#async)
- [Raw HTTP Response](#raw-http-response)
- [Reference](#reference)
  * [`automationtestwithsubmodule.greetings.hello`](#automationtestwithsubmodulegreetingshello)

<!-- tocstop -->

## Requirements<a id="requirements"></a>

Python >=3.7

## Installation<a id="installation"></a>

```sh
pip install automation-test-with-submodule-python-sdk==1.0.9
```

## Getting Started<a id="getting-started"></a>

```python
from pprint import pprint
from automation_test_with_submodule import AutomationTestWithSubmodule, ApiException

automationtestwithsubmodule = AutomationTestWithSubmodule()

try:
    # Get a simple greeting!!!
    hello_response = automationtestwithsubmodule.greetings.hello()
    print(hello_response)
except ApiException as e:
    print("Exception when calling GreetingsApi.hello: %s\n" % e)
    pprint(e.body)
    pprint(e.headers)
    pprint(e.status)
    pprint(e.reason)
    pprint(e.round_trip_time)
```

## Async<a id="async"></a>

`async` support is available by prepending `a` to any method.

```python
import asyncio
from pprint import pprint
from automation_test_with_submodule import AutomationTestWithSubmodule, ApiException

automationtestwithsubmodule = AutomationTestWithSubmodule()


async def main():
    try:
        # Get a simple greeting!!!
        hello_response = await automationtestwithsubmodule.greetings.ahello()
        print(hello_response)
    except ApiException as e:
        print("Exception when calling GreetingsApi.hello: %s\n" % e)
        pprint(e.body)
        pprint(e.headers)
        pprint(e.status)
        pprint(e.reason)
        pprint(e.round_trip_time)


asyncio.run(main())
```

## Raw HTTP Response<a id="raw-http-response"></a>

To access raw HTTP response values, use the `.raw` namespace.

```python
from pprint import pprint
from automation_test_with_submodule import AutomationTestWithSubmodule, ApiException

automationtestwithsubmodule = AutomationTestWithSubmodule()

try:
    # Get a simple greeting!!!
    hello_response = automationtestwithsubmodule.greetings.raw.hello()
    pprint(hello_response.body)
    pprint(hello_response.body["message"])
    pprint(hello_response.headers)
    pprint(hello_response.status)
    pprint(hello_response.round_trip_time)
except ApiException as e:
    print("Exception when calling GreetingsApi.hello: %s\n" % e)
    pprint(e.body)
    pprint(e.headers)
    pprint(e.status)
    pprint(e.reason)
    pprint(e.round_trip_time)
```


## Reference<a id="reference"></a>
### `automationtestwithsubmodule.greetings.hello`<a id="automationtestwithsubmodulegreetingshello"></a>

Get a simple greeting!!!

#### 🛠️ Usage<a id="🛠️-usage"></a>

```python
hello_response = automationtestwithsubmodule.greetings.hello()
```

#### 🔄 Return<a id="🔄-return"></a>

[`HelloResponse`](./automation_test_with_submodule/pydantic/hello_response.py)

#### 🌐 Endpoint<a id="🌐-endpoint"></a>

`/hello` `get`

[🔙 **Back to Table of Contents**](#table-of-contents)

---


## Author<a id="author"></a>
This Python package is automatically generated by [Konfig](https://konfigthis.com)
