# autotec-api-python-client
API for methods pertaining to all AutoTec services

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.10
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import autotec 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import autotec
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import autotec
from autotec.rest import ApiException
from pprint import pprint

# Configure API key authorization: CustomerAuthorizer
autotec.configuration.api_key['Unused'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# autotec.configuration.api_key_prefix['Unused'] = 'Bearer'
# Configure API key authorization: api_key
autotec.configuration.api_key['x-api-key'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# autotec.configuration.api_key_prefix['x-api-key'] = 'Bearer'
# create an instance of the API class
api_instance = autotec.VehicleApi()
x_api_key = 'x_api_key_example' # str | the AutoTec assigned authentication credential for the calling customer
x_autotec_id = 'x_autotec_id_example' # str | the AutoTec assigned identification id for the calling customer
request = autotec.RiskCalculationRequest() # RiskCalculationRequest | The calculation request

try:
    # Calculates Risk of Loss for Requested Vehicles
    api_response = api_instance.calc_risk(x_api_key, x_autotec_id, request)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling VehicleApi->calc_risk: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api.prod.autotec.com/1_0_10*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*VehicleApi* | [**calc_risk**](docs/VehicleApi.md#calc_risk) | **POST** /vehicle/risk | Calculates Risk of Loss for Requested Vehicles
*VehicleApi* | [**history_full**](docs/VehicleApi.md#history_full) | **POST** /vehicle/history/full | Retrieves Historical Activity for Requested Vehicles
*DefaultApi* | [**vehicle_history_full_options**](docs/DefaultApi.md#vehicle_history_full_options) | **OPTIONS** /vehicle/history/full | 
*DefaultApi* | [**vehicle_risk_options**](docs/DefaultApi.md#vehicle_risk_options) | **OPTIONS** /vehicle/risk | 


## Documentation For Models

 - [Empty](docs/Empty.md)
 - [HistoryRecord](docs/HistoryRecord.md)
 - [HistoryRequest](docs/HistoryRequest.md)
 - [HistoryResponse](docs/HistoryResponse.md)
 - [RiskCalculationRequest](docs/RiskCalculationRequest.md)
 - [RiskCalculationResponse](docs/RiskCalculationResponse.md)
 - [Vehicle](docs/Vehicle.md)
 - [VehicleHistory](docs/VehicleHistory.md)
 - [VehicleInformation](docs/VehicleInformation.md)
 - [VehicleOwnershipActivity](docs/VehicleOwnershipActivity.md)
 - [VehicleRequestAttribute](docs/VehicleRequestAttribute.md)
 - [VehicleRiskRequestAttribute](docs/VehicleRiskRequestAttribute.md)
 - [VehicleRiskResult](docs/VehicleRiskResult.md)
 - [VehicleScoring](docs/VehicleScoring.md)


## Documentation For Authorization


## CustomerAuthorizer

- **Type**: API key
- **API key parameter name**: Unused
- **Location**: HTTP header

## api_key

- **Type**: API key
- **API key parameter name**: x-api-key
- **Location**: HTTP header


## Author



